/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * FieldElem.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.generating.FieldElem;

import org.netbeans.test.java.Common;
import org.openide.src.Type;
import java.lang.reflect.Modifier;
import org.netbeans.junit.*;

/** <B>Java Module General API Test: FieldElement</B>
 * <BR><BR><I>What it tests:</I><BR>
 * Creating and handling with FieldElement.
 * Test is focused on checking of correctness of generated code.
 * <BR><BR><I>How it works:</I><BR>
 * FieldElements are created and customized using setters and then added using ClassElement.addField() into ClassElement.
 * These actions cause generating of .java code. This code is compared with supposed one.
 * <BR><BR><I>Output:</I><BR>
 * Generated Java code.
 * <BR><BR><I>Possible reasons of failure:</I><BR>
 * <U>Fields are not inserted properly:</U><BR>
 * If there are some fields in .diff file.
 * <BR><BR><U>Fields have bad properties (e.g. modifiers, return type)</U><BR>
 * See .diff file to get which ones
 * <BR><BR><U>Bad indentation</U><BR>
 * This is probably not a bug of Java Module. (->Editor Bug)
 * In .diff file could be some whitespaces.
 * <BR><BR><U>Exception occured:</I><BR>
 * See .log file for StackTrace
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */


public class FieldElem extends org.netbeans.test.java.XRunner {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public FieldElem() {
        super("");
    }
    
    public FieldElem(java.lang.String testName) {
        super(testName);
    }
    
    public static NbTest suite() {
        return new NbTestSuite(FieldElem.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */    
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        org.openide.src.ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        boolean passed = true;
        
        //let's add some fields newField1 .. newField4
        
        int i=1;
        clazz.addField(Common.createField(Common.getFieldName(i++),Modifier.PUBLIC | Modifier.STATIC , Type.BOOLEAN));
        clazz.addField(Common.createField(Common.getFieldName(i++),Modifier.PRIVATE | Modifier.STATIC , Type.INT));
        clazz.addField(Common.createField(Common.getFieldName(i++),Modifier.PROTECTED,Type.BOOLEAN));
        clazz.addField(Common.createField(Common.getFieldName(i++),Modifier.SYNCHRONIZED | Modifier.PUBLIC,Type.FLOAT));
        
        // now 4 methods should be in hierarchy lets' look at them
        if (clazz.getFields().length  != 4) {
            passed = false;
            log("Fields were not properly added");
        }
        
        org.openide.src.FieldElement fe=clazz.getField(org.openide.src.Identifier.create(Common.getFieldName(1)));
        if (fe==null) {
            passed = false;
            log("Field not found");
        } else {
            if (!fe.getName().equals(org.openide.src.Identifier.create(Common.getFieldName(1)))){
                passed = false;
                log("getName failed");
            }
            if (!(fe.getModifiers()==(Modifier.PUBLIC| Modifier.STATIC))){
                passed = false;
                log("getModifiers failed");
            }
            if (!fe.getType().equals(Type.BOOLEAN)){
                passed = false;
                log("getReturn failed");
            }
/*
            if (!(fe.getDeclaringClass().getName().getName().equals(name))){
                passed = false;
                log("getDeclaringClass failed");
            }
 */
        }
        return passed;
    }
    
    /**
     */    
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceFieldElem";
        packageName = "org.netbeans.test.java.testsources";
    }
}
