/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * FieldChanged.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.eventfiring.FieldChanged;

import org.netbeans.test.java.Common;
import org.openide.src.*;
import java.lang.reflect.Modifier;
import org.netbeans.junit.*;
import org.netbeans.test.java.eventfiring.*;
import org.openide.loaders.DataObject;

/**
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */

public class FieldChanged extends org.netbeans.test.java.XRunner {
    
    final static int DELAY = 2000;
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public FieldChanged() {
        super("");
    }
    
    public FieldChanged(java.lang.String testName) {
        super(testName);
    }
    
    public static NbTest suite() {
        return new NbTestSuite(FieldChanged.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        org.openide.src.ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        System.setProperty(org.netbeans.test.java.eventfiring.MyListener.RESULT_KEY,"");
        boolean passed = true;
        
        org.netbeans.modules.java.JavaDataObject DO = (org.netbeans.modules.java.JavaDataObject)  clazz.getSource().getCookie(org.netbeans.modules.java.JavaDataObject.class);
        org.openide.cookies.ConnectionCookie cc = (org.openide.cookies.ConnectionCookie)  DO.getCookie(org.openide.cookies.ConnectionCookie.class);
        MyListener  l = new MyListener();
        //org.netbeans.modules.java.JavaConnections.Type t = new org.netbeans.modules.java.JavaConnections.Type(org.netbeans.modules.java.JavaConnections.TYPE_ALL);
        
        Thread.currentThread().sleep(DELAY*3);
        
        //cc.register(t, l);
        org.openide.src.FieldElement fe = Common.createField("newField",java.lang.reflect.Modifier.PUBLIC | java.lang.reflect.Modifier.STATIC , org.openide.src.Type.BOOLEAN);
        clazz.addField(fe);
        
        fe = clazz.getField(org.openide.src.Identifier.create("newField"));
        
        fe.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent ev) {
                if (!ev.getPropertyName().equals("cookie")) { //hack to slow event firing
                    ref("PropertyChanged: "+ev.getPropertyName());
                }
            }
        });
        
        Thread.currentThread().sleep(DELAY);
        
        fe.setType(org.openide.src.Type.FLOAT);
        Thread.currentThread().sleep(DELAY);
        
        fe.setInitValue("3");
        Thread.currentThread().sleep(DELAY);
        
        fe.setModifiers(java.lang.reflect.Modifier.PROTECTED);
        Thread.currentThread().sleep(DELAY);
        
        fe.setName(org.openide.src.Identifier.create("ranamedField"));
        Thread.currentThread().sleep(DELAY);
        
        //cc.unregister(t, l);
        
        ref(System.getProperty(MyListener.RESULT_KEY));
        
        return passed;
    }
    
    protected boolean writeResult(DataObject DO) {
        return true;
    }
    
    /**
     */
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceEventFiringFieldChanged";
        packageName = "org.netbeans.test.java.testsources";
    }
    
    protected void tearDown() {
        try {
            Thread.sleep(2*DELAY);
        } catch (InterruptedException e) {
        }
        super.tearDown();
    }
    
}
