/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * OverrideMethodsOperator.java
 *
 * Created on 12/4/04 7:32 PM
 */
package org.netbeans.jellytools.modules.java;

import org.netbeans.jemmy.operators.*;

/** Class implementing all necessary methods for handling "Override and Implement Methods" NbDialog.
 *
 * @author Roman Strobl
 * @version 1.0
 */
public class OverrideMethodsOperator extends JDialogOperator {

    /** Creates new OverrideMethodsOperator that can handle it.
     */
    public OverrideMethodsOperator() {
        super(org.netbeans.jellytools.Bundle.getString("org.netbeans.modules.java.tools.Bundle", "LBL_OverridePanel2_Title"));
    }

    private JLabelOperator _lblSelectTheMethodsToOverrideOrImplementForMultipleSelectionUseCTRLKey;
    private JCheckBoxOperator _cbShowSuperclassesAndInterfaces;
    private JCheckBoxOperator _cbShowAbstractMethodsOnly;
    private JLabelOperator _lblAvailableSuperclassAndInterfaceMethods;
    private JTreeOperator _treeAvailableSuperclassAndInterfaceMethods;
    private JCheckBoxOperator _cbGenerateSuperCalls;
    private JCheckBoxOperator _cbCopyJavadoc;
    private JButtonOperator _btOK;
    private JButtonOperator _btCancel;


    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find "Select the methods to override or implement. For multiple selection use CTRL key." JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblSelectTheMethodsToOverrideOrImplementForMultipleSelectionUseCTRLKey() {
        if (_lblSelectTheMethodsToOverrideOrImplementForMultipleSelectionUseCTRLKey==null) {
            _lblSelectTheMethodsToOverrideOrImplementForMultipleSelectionUseCTRLKey = new JLabelOperator(this, "Select the methods to override or implement. For multiple selection use CTRL key.");
        }
        return _lblSelectTheMethodsToOverrideOrImplementForMultipleSelectionUseCTRLKey;
    }

    /** Tries to find "Show Superclasses and Interfaces" JCheckBox in this dialog.
     * @return JCheckBoxOperator
     */
    public JCheckBoxOperator cbShowSuperclassesAndInterfaces() {
        if (_cbShowSuperclassesAndInterfaces==null) {
            _cbShowSuperclassesAndInterfaces = new JCheckBoxOperator(this, "Show Superclasses and Interfaces");
        }
        return _cbShowSuperclassesAndInterfaces;
    }

    /** Tries to find "Show Abstract Methods Only" JCheckBox in this dialog.
     * @return JCheckBoxOperator
     */
    public JCheckBoxOperator cbShowAbstractMethodsOnly() {
        if (_cbShowAbstractMethodsOnly==null) {
            _cbShowAbstractMethodsOnly = new JCheckBoxOperator(this, "Show Abstract Methods Only");
        }
        return _cbShowAbstractMethodsOnly;
    }

    /** Tries to find "Available Superclass and Interface Methods:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblAvailableSuperclassAndInterfaceMethods() {
        if (_lblAvailableSuperclassAndInterfaceMethods==null) {
            _lblAvailableSuperclassAndInterfaceMethods = new JLabelOperator(this, "Available Superclass and Interface Methods:");
        }
        return _lblAvailableSuperclassAndInterfaceMethods;
    }

    /** Tries to find null TreeView$ExplorerTree in this dialog.
     * @return JTreeOperator
     */
    public JTreeOperator treeAvailableSuperclassAndInterfaceMethods() {
        if (_treeAvailableSuperclassAndInterfaceMethods==null) {
            _treeAvailableSuperclassAndInterfaceMethods = new JTreeOperator(this);
        }
        return _treeAvailableSuperclassAndInterfaceMethods;
    }

    /** Tries to find "Generate Super Calls" JCheckBox in this dialog.
     * @return JCheckBoxOperator
     */
    public JCheckBoxOperator cbGenerateSuperCalls() {
        if (_cbGenerateSuperCalls==null) {
            _cbGenerateSuperCalls = new JCheckBoxOperator(this, "Generate Super Calls");
        }
        return _cbGenerateSuperCalls;
    }

    /** Tries to find "Copy Javadoc" JCheckBox in this dialog.
     * @return JCheckBoxOperator
     */
    public JCheckBoxOperator cbCopyJavadoc() {
        if (_cbCopyJavadoc==null) {
            _cbCopyJavadoc = new JCheckBoxOperator(this, "Copy Javadoc");
        }
        return _cbCopyJavadoc;
    }

    /** Tries to find "OK" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btOK() {
        if (_btOK==null) {
            _btOK = new JButtonOperator(this, "OK");
        }
        return _btOK;
    }

    /** Tries to find "Cancel" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btCancel() {
        if (_btCancel==null) {
            _btCancel = new JButtonOperator(this, "Cancel");
        }
        return _btCancel;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** checks or unchecks given JCheckBox
     * @param state boolean requested state
     */
    public void checkShowSuperclassesAndInterfaces(boolean state) {
        if (cbShowSuperclassesAndInterfaces().isSelected()!=state) {
            cbShowSuperclassesAndInterfaces().push();
        }
    }

    /** checks or unchecks given JCheckBox
     * @param state boolean requested state
     */
    public void checkShowAbstractMethodsOnly(boolean state) {
        if (cbShowAbstractMethodsOnly().isSelected()!=state) {
            cbShowAbstractMethodsOnly().push();
        }
    }

    /** checks or unchecks given JCheckBox
     * @param state boolean requested state
     */
    public void checkGenerateSuperCalls(boolean state) {
        if (cbGenerateSuperCalls().isSelected()!=state) {
            cbGenerateSuperCalls().push();
        }
    }

    /** checks or unchecks given JCheckBox
     * @param state boolean requested state
     */
    public void checkCopyJavadoc(boolean state) {
        if (cbCopyJavadoc().isSelected()!=state) {
            cbCopyJavadoc().push();
        }
    }

    /** clicks on "OK" JButton
     */
    public void ok() {
        btOK().push();
    }

    /** clicks on "Cancel" JButton
     */
    public void cancel() {
        btCancel().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of OverrideAndImplementMethods by accessing all its components.
     */
    public void verify() {
        lblSelectTheMethodsToOverrideOrImplementForMultipleSelectionUseCTRLKey();
        cbShowSuperclassesAndInterfaces();
        cbShowAbstractMethodsOnly();
        lblAvailableSuperclassAndInterfaceMethods();
        treeAvailableSuperclassAndInterfaceMethods();
        cbGenerateSuperCalls();
        cbCopyJavadoc();
        btOK();
        btCancel();
    }

    /** Performs simple test of OverrideMethodsOperator
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new OverrideMethodsOperator().verify();
        System.out.println("OverrideMethodsOperator verification finished.");
    }
}
