/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * MethodParameterOperator.java
 *
 * Created on 10/3/02 5:15 PM
 */
package org.netbeans.jellytools.modules.java;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jemmy.operators.*;

/** Class implementing all necessary methods for handling "Enter Method Parameter" NbPresenter.
 *
 * @author jb105785
 * @version 1.0
 */
public class MethodParameterOperator extends JDialogOperator {

    /** Creates new MethodParameterOperator that can handle it.
     */
    public MethodParameterOperator() {
        super(Bundle.getString("org.openide.explorer.propertysheet.editors.Bundle2", "LAB_EnterParameter"));
    }

    private JLabelOperator _lblType;
    private JComboBoxOperator _cboType;
    private JLabelOperator _lblName;
    private JTextFieldOperator _txtName;
    private JCheckBoxOperator _cbFinal;
    private JButtonOperator _btOK;
    private JButtonOperator _btCancel;


    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find "Type:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblType() {
        if (_lblType==null) {
            _lblType = new JLabelOperator(this, Bundle.getString("org.openide.src.nodes.Bundle", "CTL_Type"));
        }
        return _lblType;
    }

    /** Tries to find null JComboBox in this dialog.
     * @return JComboBoxOperator
     */
    public JComboBoxOperator cboType() {
        if (_cboType==null) {
            _cboType = new JComboBoxOperator(this);
        }
        return _cboType;
    }

    /** Tries to find "Name:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblName() {
        if (_lblName==null) {
            _lblName = new JLabelOperator(this, Bundle.getString("org.openide.src.nodes.Bundle", "CTL_Name"));
        }
        return _lblName;
    }

    /** Tries to find null JTextField in this dialog.
     * @return JTextFieldOperator
     */
    public JTextFieldOperator txtName() {
        if (_txtName==null) {
            _txtName = new JTextFieldOperator(this, 1);
        }
        return _txtName;
    }

    /** Tries to find "Final" JCheckBox in this dialog.
     * @return JCheckBoxOperator
     */
    public JCheckBoxOperator cbFinal() {
        if (_cbFinal==null) {
            _cbFinal = new JCheckBoxOperator(this, org.netbeans.jellytools.Bundle.getString("org.openide.explorer.propertysheet.editors.Bundle2", "CTL_Final"));
        }
        return _cbFinal;
    }

    /** Tries to find "OK" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btOK() {
        if (_btOK==null) {
            _btOK = new JButtonOperator(this, Bundle.getString("org.openide.Bundle", "CTL_OK"));
        }
        return _btOK;
    }

    /** Tries to find "Cancel" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btCancel() {
        if (_btCancel==null) {
            _btCancel = new JButtonOperator(this, Bundle.getString("org.openide.Bundle", "CTL_CANCEL"));
        }
        return _btCancel;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** returns selected item for cboType
     * @return String item
     */
    public String getSelectedType() {
        return cboType().getSelectedItem().toString();
    }

    /** selects item for cboType
     * @param item String item
     */
    public void selectType(String item) {
        cboType().selectItem(item);
    }

    /** types text for cboType
     * @param text String text
     */
    public void typeType(String text) {
        cboType().typeText(text);
    }

    /** gets text for txtName
     * @return String text
     */
    public String getName() {
        return txtName().getText();
    }

    /** sets text for txtName
     * @param text String text
     */
    public void setName(String text) {
        txtName().setText(text);
    }

    /** types text for txtName
     * @param text String text
     */
    public void typeName(String text) {
        txtName().typeText(text);
    }

    /** checks or unchecks given JCheckBox
     * @param state boolean requested state
     */
    public void checkFinal(boolean state) {
        if (cbFinal().isSelected()!=state) {
            cbFinal().push();
        }
    }

    /** clicks on "OK" JButton
     */
    public void oK() {
        btOK().push();
    }

    /** clicks on "Cancel" JButton
     */
    public void cancel() {
        btCancel().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of MethodParameterOperator by accessing all its components.
     */
    public void verify() {
        lblType();
        cboType();
        lblName();
        txtName();
        cbFinal();
        btOK();
        btCancel();
    }

    /** Performs simple test of MethodParameterOperator
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new MethodParameterOperator().verify();
        System.out.println("MethodParameterOperator verification finished.");
    }
}

