/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jellytools.modules.java;

import java.awt.Container;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTableOperator;

/** Class implementing all necessary methods for handling "Fix Imports" NbDialog.
 *
 * @author Roman Strobl
 * @version 1.0
 */
public class FixImportsOperator extends NbDialogOperator {
    
    /** Creates new FixImports that can handle it. */
    public FixImportsOperator() {
        super(waitFixImportDialog());
    }

    private JLabelOperator _lblHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml;
    private JTableOperator _tabHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml;
    // "<html>The following class names were found in more than one package. Select the fully qualified name to use in the import statement:</html>"
    private static final String INTRO_LABEL = Bundle.getString("org.netbeans.modules.editor.java.Bundle", "FixDupImportStmts_IntroLbl");
    // "Fix Imports"
    private static final String TITLE = Bundle.getString("org.netbeans.modules.editor.java.Bundle", "FixDuplicateImports_dlgTitle");

    /** Progress dialog with the same title can be found first. Then we have to check whether
     * it contains correct label and if not wait for next dialog.
     */
    private static JDialog waitFixImportDialog() {
        JDialogOperator candidate = new JDialogOperator(TITLE);
        JLabel introLabel = JLabelOperator.findJLabel((Container)candidate.getSource(), INTRO_LABEL, true, true);
        if(introLabel == null) {
            candidate.waitClosed();
            candidate = new JDialogOperator(TITLE);
        }
        return (JDialog)candidate.getSource();
    }
    
    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find "<html>The following class names were found in more than one package. Select the fully qualified name to use in the import statement:</html>" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml() {
        if (_lblHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml==null) {
            _lblHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml = new JLabelOperator(this, INTRO_LABEL);
        }
        return _lblHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml;
    }

    /** Tries to find null FixDuplicateImportStmts$JTableX in this dialog.
     * @return JTableOperator
     */
    public JTableOperator tabHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml() {
        if (_tabHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml==null) {
            _tabHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml = new JTableOperator(this);
        }
        return _tabHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml;
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of FixImports by accessing all its components.
     */
    public void verify() {
        lblHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml();
        tabHtmlTheFollowingClassNamesWereFoundInMoreThanOnePackageSelectTheFullyQualifiedNameToUseInTheImportStatementHtml();
        btOK();
        btCancel();
    }

    /** Performs simple test of FixImports
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new FixImportsOperator().verify();
        System.out.println("FixImports verification finished.");
    }
}

