/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ClassCustomizerOperator.java
 *
 * Created on 12/22/04 1:54 PM
 */
package org.netbeans.jellytools.modules.java;

import org.netbeans.jemmy.operators.*;
import org.netbeans.jemmy.util.NameComponentChooser;

/** Class implementing all necessary methods for handling ClassCustomizerOperator NbDialog.
 *
 * @author Roman Strobl
 * @version 1.0
 */
public class ClassCustomizerOperator extends JDialogOperator {

    /** Creates new NewClassProperties that can handle it.
     */
    public ClassCustomizerOperator(String name) {
        super(name);
    }

    private JSplitPaneOperator _sppJSplitPane;
    private JTextAreaOperator _txtJTextArea;
    private JLabelOperator _lblNewClass;
    private JButtonOperator _btJButton;
    private JTableOperator _tabPropertiesTable;
    private JButtonOperator _btClose;


    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find null JSplitPane in this dialog.
     * @return JSplitPaneOperator
     */
    public JSplitPaneOperator sppJSplitPane() {
        if (_sppJSplitPane==null) {
            _sppJSplitPane = new JSplitPaneOperator(this);
        }
        return _sppJSplitPane;
    }

    /** Tries to find null JTextArea in this dialog.
     * @return JTextAreaOperator
     */
    public JTextAreaOperator txtJTextArea() {
        if (_txtJTextArea==null) {
            _txtJTextArea = new JTextAreaOperator(sppJSplitPane());
        }
        return _txtJTextArea;
    }

    /** Tries to find "NewClass" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblNewClass() {
        if (_lblNewClass==null) {
            _lblNewClass = new JLabelOperator(sppJSplitPane(), "NewClass");
        }
        return _lblNewClass;
    }

    /** Tries to find null JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btJButton() {
        if (_btJButton==null) {
            _btJButton = new JButtonOperator(sppJSplitPane());
        }
        return _btJButton;
    }

    /** Tries to find null SheetTable in this dialog.
     * @return JTableOperator
     */
    public JTableOperator tabPropertiesTable() {
        if (_tabPropertiesTable==null) {
            _tabPropertiesTable = new JTableOperator(sppJSplitPane());
        }
        return _tabPropertiesTable;
    }

    /** Tries to find "Close" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btClose() {
        if (_btClose==null) {
            _btClose = new JButtonOperator(this, "Close");
        }
        return _btClose;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** gets text for txtJTextArea
     * @return String text
     */
    public String getJTextArea() {
        return txtJTextArea().getText();
    }

    /** sets text for txtJTextArea
     * @param text String text
     */
    public void setJTextArea(String text) {
        txtJTextArea().setText(text);
    }

    /** types text for txtJTextArea
     * @param text String text
     */
    public void typeJTextArea(String text) {
        txtJTextArea().typeText(text);
    }

    /** clicks on null JButton
     */
    public void jButton() {
        btJButton().push();
    }

    /** clicks on "Close" JButton
     */
    public void close() {
        btClose().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of ClassCustomizerOperator by accessing all its components.
     */
    public void verify() {
        sppJSplitPane();
        txtJTextArea();
        lblNewClass();
        btJButton();
        tabPropertiesTable();
        btClose();
    }

    /** Performs simple test of ClassCustomizerOperator
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new ClassCustomizerOperator("Edit New Class").verify();
        System.out.println("ClassCustomizerOperator verification finished.");
    }
}
