/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.java.storagebuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.modules.javacore.classpath.MergedClassPathImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.CodebasesResolver;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileStateInvalidException;

public class Main {
    
    static String[] names = new String[0];
    
    static {
        System.setProperty("org.netbeans.javacore.eagerlyParse", ""); // NOI18N
        // get file names to preparse
        String s = System.getProperty("preparse.files", "");
        if (!"".equals(s)) {
            File f = new File(s);
            StringBuffer classes = new StringBuffer(1024);
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                byte[] c = new byte[1024];
                int bytesread;
                while ((bytesread=is.read(c)) > 0) {
                    classes.append(new String(c,0,bytesread));
                }
                names = classes.toString().split(":"); // NOI18N
            } catch (FileNotFoundException e) {
                System.err.println("File does not exist.");
                System.err.println(e);
            } catch (IOException e) {
                System.err.println("File does not exist.");
                System.err.println(e);
            } finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                } catch (IOException e) {
                    // ignore this
                }
            }
        }
    }
    
    private static JavaModelPackage javaPckg = null;
    
    public static final int OK = 0;
    public static final int FAILED = 1;
    
    /** Creates MDR storage for rt.jar and src.zip in a given list of jdks + scans jars explicitly listed.
     * @param jdks Path to jdk homes (will scan src.zip and rt.jar for these) and other jars to be scanned.
     * @param destDir Destination directory of the resulting MDR storage files.
     * @return Error code (OK or FAILED).
     */
    public static int prebuildJDKStorages(String[] jdks, String destDir) {
        int result;
        File dir;
        
        ArrayList/*<String>*/ jarsList = new ArrayList(jdks.length * 2);
        ArrayList/*<String[]>*/ resNamesList = new ArrayList(jdks.length * 2);
        for (int i = 0; i < jdks.length; i++) {
            if (jdks[i].endsWith(".jar") || jdks[i].endsWith(".zip")) { // NOI18N
                jarsList.add(jdks[i]);
                resNamesList.add(new String[0]);
            } else {
                dir = new File(jdks[i]);
                if (!dir.exists()) {
                    System.out.println("JDK home directory not found: " + jdks[i]); // NOI18N
                    return FAILED;
                }
                if (!jdks[i].endsWith(File.separator)) {
                    jdks[i] = jdks[i] + File.separator;
                }
                jarsList.add(jdks[i] + "jre" + File.separator + "lib" + File.separator + "rt.jar"); // NOI18N
                String resNames[] = new String[names.length];
                for (int j = 0; j < names.length; j++) {
                    resNames[j] = names[j].concat(".class"); // NOI18N
                }
                resNamesList.add(resNames);
                jarsList.add(jdks[i] + "src.zip"); // NOI18N
                resNames = new String[names.length];
                for (int j = 0; j < names.length; j++) {
                    resNames[j] = names[j].concat(".java"); // NOI18N
                }
                resNamesList.add(resNames);
            }
        }
        String jars[] = (String[]) jarsList.toArray(new String[jarsList.size()]);
        String resNames[][] = (String[][]) resNamesList.toArray(new String[jarsList.size()][]);
        return prebuildJars(jars, new boolean[jars.length], resNames, destDir);
    }
    
    /** Creates MDR storage for given jars.
     * @param jars Array of names of jars to be scanned.
     * @param deepParse Indicates whether a given jar should be scanned deeply (e.g. pre-parse also the methods, etc., not just classes).
     * @param names If deepParse == false for a given jar, this parameter may contain an array of names (with paths relative from the jar-root)
     *              of files that should be scanned deeply.
     * @param destDir Destination directory for the resulting MDR storage files.
     * @return Error code (OK or FAILED).
     */
    public static int prebuildJars(String[] jars, boolean[] deepParse, String[][] names, String destDir) {
        int result;
        File dir;
        
        dir = new File(destDir);
        if (!dir.exists()) {
            System.out.println("Target directory does not exist: " + destDir); // NOI18N
            return FAILED;
        }
        String storagesDir = System.getProperty("mdr.filename"); // NOI18N
        if (storagesDir == null) {
            System.out.println("mdr.filename property not specified"); // NOI18N
            return FAILED;
        }
        int index = storagesDir.lastIndexOf(File.separator);
        if (index > 0) {
            String dirName = storagesDir.substring(0,index);
            dir = new File(dirName);
            if (!dir.exists()) {
                System.out.println("mdr storage directory does not exist: " + dirName); // NOI18N
                return FAILED;
            }
        }
        for (int x = 0; x < jars.length; x++) {
            dir = new File(jars[x]);
            if (!dir.exists()) {
                System.out.println("Jar not found: " + jars[x]); // NOI18N
                return FAILED;
            }
        }
        
        if (!destDir.endsWith(File.separator)) {
            destDir = destDir + File.separator;
        }
        try {
            String jarSimpleNames[] = new String[jars.length];
            for (int i = 0; i < jars.length; i++) {
                int pos = jars[i].lastIndexOf(File.separator);
                jarSimpleNames[i] = pos >= 0 ? jars[i].substring(pos + 1) : jars[i];
                pos = jarSimpleNames[i].lastIndexOf('.');
                if (pos >= 0) jarSimpleNames[i] = jarSimpleNames[i].substring(0, pos);
                result = preparseFile(jars[i], jarSimpleNames[i], deepParse[i]);
                if (result != OK)
                    return result;
                if (names[i].length > 0 && javaPckg != null) {
                    preparseResources(names[i]);
                }
            }
            MDRepository repository = MDRManager.getDefault().getRepository("org.netbeans.java"); // NOI18N
            repository.shutdown();
            for (int i = 0; i < jars.length; i++) {
                result = saveFile(jars[i], jarSimpleNames[i], destDir); // NOI18N
                if (result != OK)
                    return result;
            }
        } catch (FileStateInvalidException e) {
            System.out.println("process failed: " + e.getMessage()); // NOI18N
            System.out.flush();
            return FAILED;
        } catch (MalformedURLException e) {
            System.out.println("process failed: " + e.getMessage()); // NOI18N
            System.out.flush();
            return FAILED;
        }
        return OK;
    }

    private static int preparseFile(String filename, String type, boolean preparseFeatures) throws FileStateInvalidException, MalformedURLException {
        System.out.println("preparsing " + filename); // NOI18N
        File file = new File(filename);
        FileObject archive = FileUtil.toFileObject(file);
        if (archive == null) {
            System.out.println("file not found: " + filename); // NOI18N
            return FAILED;
        }
        FileObject archiveRoot = FileUtil.getArchiveRoot(archive);
        URL archiveUrl = archiveRoot.getURL();
        MergedClassPathImplementation.getDefault().addRoot(archiveUrl);
        CodebasesResolver.resolve();
        // pre-parse
        NBMDRepositoryImpl impl = (NBMDRepositoryImpl) JavaMetamodel.getDefaultRepository();
        javaPckg = JavaMetamodel.getManager().getJavaExtent(archiveRoot);
        if (preparseFeatures) {
            Resource[] resources = (Resource[]) javaPckg.getResource().refAllOfClass().toArray(new Resource[0]);
            int p = 0, closed = 0;
            impl.beginTrans(true);
            impl.disableEvents();
            try {
                for (int i = 0; i < resources.length; i++) {
                    resources[i].getImports();
                    resources[i] = null;
                    int newP = i * 100 / resources.length;
                    long free = Runtime.getRuntime().freeMemory();
                    long total = Runtime.getRuntime().totalMemory();
                    if (free < (total / 4)) {
                        impl.endTrans();
                        System.gc();
                        impl.beginTrans(true);
                        impl.disableEvents();
                        closed = i;
                    }
                    if (newP != p) {
                        if (newP % 10 == 0) {
                            System.out.println(newP + "%"); // NOI18N
                            System.out.flush();
                        }
                        p = newP;
                    }
                }
                System.out.println("100%"); // NOI18N
                System.out.flush();
            } catch (Exception e) {
                System.out.println(" ... failed: " + e.getMessage()); // NOI18N
                System.out.flush();
                return FAILED;
            } finally {
                impl.endTrans();
            }
        }
        System.out.println(" ... done"); // NOI18N
        String uri = ((JMManager) JMManager.getManager()).getRootURI(archiveRoot);
        RefPackage extent = (JavaModelPackage)impl.getExtent("codebase:" + uri); // NOI18N
        if ((JavaModelPackage)impl.getExtent("codebase:" + type) != null) { // NOI18N
            System.out.println("Cannot rename extent, there is already one of the same name."); // NOI18N
            System.out.println("It seems that storage files already existed in the temp mdr directory (specified by mdr.filename property)."); // NOI18N
            return FAILED;
        }
        impl.renameExtent(extent, "codebase:" + type); // NOI18N
        return OK;
    }

    private static int saveFile(String filename, String type, String saveToDir) throws FileStateInvalidException, MalformedURLException {
        System.out.print("copying storages for " + filename); // NOI18N
        File file = new File(filename);
        FileObject archive = FileUtil.toFileObject(file);
        FileObject archiveRoot = FileUtil.getArchiveRoot(archive);
        URL archiveUrl = archiveRoot.getURL();
        NBMDRepositoryImpl impl = (NBMDRepositoryImpl) JavaMetamodel.getDefaultRepository();
        try {
            String hash = JMManager.computePreparsedHash(file, JMManager.BYTES4MD5);
            String uri = ((JMManager) JMManager.getManager()).getRootURI(archiveRoot);
            JMManager m = (JMManager) JMManager.getManager();
            String strName = m.getFileName(m.getValidName(m.getRootURI(archiveRoot)));
            if (!JMManager.copyStorage(strName, saveToDir + type + "-" + hash, true)) { // NOI18N
                return FAILED;
            }
            System.out.println(" ... done"); // NOI18N
        } catch (Exception e) {
            System.out.println(" ... failed: " + e.getMessage()); // NOI18N
            return FAILED;
        }
        return OK;
    }
    
    private static int preparseResources(String[] names) {
        NBMDRepositoryImpl impl = (NBMDRepositoryImpl) JavaMetamodel.getDefaultRepository();
        for (int i = 0; i < names.length; i++) {
            impl.beginTrans(true);
            impl.disableEvents();
            try {
                Resource r = javaPckg.getResource().resolveResource(names[i], false);
                if (r == null) {
                    System.out.println("null for name: '" + names[i] + "'."); // NOI18N
                } else {
                    System.out.println("name: '" + r.getName() + "'."); // NOI18N
                    r.getImports();
                }
            } catch (Exception e) {
                System.out.println(" ... failed: " + e.getMessage()); // NOI18N
                System.out.flush();
                return FAILED;
            } finally {
                impl.endTrans();
            }
        }
        return OK;
    }
    
    public static void main(String[] args) throws IOException {
        String[] jdks = new String[args.length - 1];
        for (int x = 1; x < args.length; x++) {
            jdks[x - 1] = args[x];
        }
        System.exit(prebuildJDKStorages(jdks, args[0]));
    }

}
