/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.nodes;

import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.beans.FeatureDescriptor;
import java.util.ResourceBundle;

import javax.swing.*;
import javax.swing.border.*;

import org.openide.src.*;
import org.openide.explorer.propertysheet.*;
import org.openide.*;
import org.openide.util.Utilities;
import org.openide.util.NbBundle;

import org.openide.src.nodes.SourceEditSupport.ExceptionalRunnable;

/** Customizer for MethodElement and ConstructorElement
 *
 * @author Petr Hamernik
 */
public class MethodCustomizer extends JPanel {
    /** Source of the localized human presentable strings. */
    static ResourceBundle bundle = NbBundle.getBundle(MethodCustomizer.class);

    /** Predefined types in the type combo */
    private static final String[] COMMON_TYPES = {
        "void", // NOI18N
        "String", // NOI18N
        "boolean", // NOI18N
        "char", // NOI18N
        "int", // NOI18N
        "long", // NOI18N
        "byte", // NOI18N
        "short", // NOI18N
        "float", // NOI18N
        "double" // NOI18N
    };

    /** Edited constructor */
    ConstructorElement element;

    /** In case that method is edited - this field holds
    * the reference to it. Otherwise (Constructor) this field
    * is <CODE>null</CODE>.
    */
    MethodElement method;
    
    boolean isOK = true;

    /** Create new MethodCustomizer component
    * @param element The method or constructor to be customized
    */
    public MethodCustomizer(ConstructorElement element) {
        this.element = element;
        this.method = (element instanceof MethodElement) ?
                      (MethodElement) element : null;

        initComponents ();

        // borders
        methodPanel.setBorder (new CompoundBorder(
                                   new TitledBorder(bundle.getString("CTL_MethodFrame")),
                                   new EmptyBorder(new java.awt.Insets(5, 5, 5, 5)))
                              );
        modifierPanel.setBorder (new TitledBorder(bundle.getString("CTL_Modifiers")));
        paramsPanel.setBorder (new TitledBorder(bundle.getString("CTL_Parameters")));
        exceptionsPanel.setBorder (new TitledBorder(bundle.getString("CTL_Exceptions")));

        // modifiers
        PropertyPanel modifEditor = ElementBeanModel.createModifiersPanel(element);
        FeatureDescriptor fd = modifEditor.getProperty();
        final String mnc = String.valueOf(KeyEvent.CHAR_UNDEFINED);
        fd.setValue("ModifierPanel_Modifier_Abstract_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Final_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Static_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Synchronized_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Transient_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Volatile_Mnemonic", mnc); // NOI18N
        fd.setValue("ModifierPanel_Modifier_Native_Mnemonic", mnc); // NOI18N
        modifierPanel.add(modifEditor, BorderLayout.CENTER);

        // name
        nameTextField.setText(element.getName().toString());
        if (method == null) {
            nameTextField.setEnabled(false);
            returnCombo.setEnabled(false);
        }
        else {
            returnCombo.setSelectedItem(method.getReturn().toString());
        }

        // parameters
        PropertyPanel paramsEditor = ElementBeanModel.createPropertyPanel(element, ElementProperties.PROP_PARAMETERS);
        fd = paramsEditor.getProperty();
        fd.setValue("mnemonic_Add", bundle.getString("CTL_Parameters_Mnemonic_Add")); // NOI18N
        fd.setValue("mnemonic_Remove", bundle.getString("CTL_Parameters_Mnemonic_Remove")); // NOI18N
        fd.setValue("mnemonic_Up", bundle.getString("CTL_Parameters_Mnemonic_Up")); // NOI18N
        fd.setValue("mnemonic_Down", bundle.getString("CTL_Parameters_Mnemonic_Down")); // NOI18N
        fd.setValue("mnemonic_Edit", bundle.getString("CTL_Parameters_Mnemonic_Edit")); // NOI18N
        paramsPanel.add(paramsEditor, BorderLayout.CENTER);
        
        // exceptions
        PropertyPanel exceptionsEditor = ElementBeanModel.createPropertyPanel(element, ElementProperties.PROP_EXCEPTIONS);
        fd = exceptionsEditor.getProperty();
        fd.setValue("mnemonic_Add", bundle.getString("CTL_Exceptions_Mnemonic_Add"));
        fd.setValue("mnemonic_Remove", bundle.getString("CTL_Exceptions_Mnemonic_Remove"));
        fd.setValue("mnemonic_Up", bundle.getString("CTL_Exceptions_Mnemonic_Up"));
        fd.setValue("mnemonic_Down", bundle.getString("CTL_Exceptions_Mnemonic_Down"));
        fd.setValue("mnemonic_Edit", bundle.getString("CTL_Exceptions_Mnemonic_Edit"));
        exceptionsPanel.add(exceptionsEditor, BorderLayout.CENTER);

        //mnemonics
        jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0)); // NOI18N
        jLabel2.setDisplayedMnemonic(bundle.getString("CTL_MethodType_Mnemonic").charAt(0));  // NOI18N
        initAccessibility();
    }
    
    public void addNotify() {
        super.addNotify();
        
        int len = nameTextField.getText().length();
        nameTextField.setCaretPosition(0);
        nameTextField.moveCaretPosition(len);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        methodPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        returnCombo = new javax.swing.JComboBox(COMMON_TYPES);
        jPanel1 = new javax.swing.JPanel();
        modifierPanel = new javax.swing.JPanel();
        paramsPanel = new javax.swing.JPanel();
        exceptionsPanel = new javax.swing.JPanel();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 6, 6, 6)));
        methodPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints2;
        
        jLabel1.setText(bundle.getString("CTL_Name"));
        jLabel1.setLabelFor(nameTextField);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(10, 0, 8, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        methodPanel.add(jLabel1, gridBagConstraints2);
        
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints2.insets = new java.awt.Insets(10, 0, 8, 0);
        gridBagConstraints2.weightx = 1.0;
        methodPanel.add(nameTextField, gridBagConstraints2);
        
        jLabel2.setText(bundle.getString("CTL_ReturnType"));
        jLabel2.setLabelFor(returnCombo);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(0, 0, 0, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        methodPanel.add(jLabel2, gridBagConstraints2);
        
        returnCombo.setEditable(true);
        returnCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                returnComboActionPerformed(evt);
            }
        });
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints2.weightx = 1.0;
        methodPanel.add(returnCombo, gridBagConstraints2);
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints2.weighty = 1.0;
        methodPanel.add(jPanel1, gridBagConstraints2);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 1.0;
        add(methodPanel, gridBagConstraints1);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(0, 5, 0, 0);
        add(modifierPanel, gridBagConstraints1);
        
        paramsPanel.setLayout(new java.awt.BorderLayout());
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(paramsPanel, gridBagConstraints1);
        
        exceptionsPanel.setLayout(new java.awt.BorderLayout());
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(exceptionsPanel, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void returnComboActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_returnComboActionPerformed
                           if (method == null)
                               return;

                           Object selItem = returnCombo.getSelectedItem();
                           Type oldValue = method.getReturn();
                           boolean ok = false;
                           
                           if (selItem!=null) {
                               try {
                                   final Type newValue = Type.parse(selItem.toString());
                                   if (!oldValue.equals(newValue)) {
                                       try {
                                           SourceEditSupport.runAsUser(method, new ExceptionalRunnable() {
                                               public void run() throws SourceException {
                                                   method.setReturn(newValue);
                                               }
                                           });
                                           ok = true;
                                       }
                                       catch (SourceException e) {
                                           ErrorManager.getDefault().notify(e);
                                       }
                                   } else
                                       return;
                               }
                               catch (IllegalArgumentException e) {
                                   ErrorManager.getDefault().annotate(
                                   e, ErrorManager.USER, null,
                                   bundle.getString("MSG_Not_Valid_Type"),
                                   null, null);
                                   ErrorManager.getDefault().notify(e);
                               }
                           }
                           isOK = ok;
                           if (!ok)
                               returnCombo.setSelectedItem(oldValue.toString());
                       }//GEN-LAST:event_returnComboActionPerformed

                       private void nameTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
                           if ((evt != null && evt.isTemporary()) || (method == null))
                               return;

                           String newName = nameTextField.getText();
                           String oldName = method.getName().toString();
                           boolean ok = false;
                           Exception x = null;
                           if (Utilities.isJavaIdentifier(newName)) {
                               if (!oldName.equals(newName)) {
                                   final Identifier id = Identifier.create(newName);
                                   try {
                                       SourceEditSupport.runAsUser(method, new ExceptionalRunnable() {
                                           public void run() throws SourceException {
                                               method.setName(id);
                                           }
                                       });
                                       ok = true;
                                   }
                                   catch (SourceException e) {
                                       ErrorManager.getDefault().notify(e);
                                   }
                               } else
                                   return;
                           } else {
                               x = new IllegalArgumentException("Invalid name"); // NOI18N
                               ErrorManager.getDefault().annotate(
                               x, ErrorManager.USER, null,
                               bundle.getString("MSG_Not_Valid_Identifier"),
                               null, null);
                           }
                           isOK = ok;
                           if (!ok) {
                               nameTextField.setText(oldName);
                           }
                           if (x != null) {
                               ErrorManager.getDefault().notify(x);
                           }
                       }//GEN-LAST:event_nameTextFieldFocusLost


                       // Variables declaration - do not modify//GEN-BEGIN:variables
                       private javax.swing.JPanel methodPanel;
                       private javax.swing.JLabel jLabel1;
                       private javax.swing.JTextField nameTextField;
                       private javax.swing.JLabel jLabel2;
                       private javax.swing.JComboBox returnCombo;
                       private javax.swing.JPanel jPanel1;
                       private javax.swing.JPanel modifierPanel;
                       private javax.swing.JPanel paramsPanel;
                       private javax.swing.JPanel exceptionsPanel;
                       // End of variables declaration//GEN-END:variables

    private void initAccessibility() {
        nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_MethodNameTextField"));
        nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_MethodNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_MethodCustomizerDialog"); // NOI18N
    }                       
    
    public boolean isOK() {
        nameTextFieldFocusLost(null);
        returnComboActionPerformed(null);
        return isOK;
    }
}
