/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.nodes;

import java.util.ResourceBundle;

import javax.swing.*;
import javax.swing.border.*;

import org.openide.src.*;
import org.openide.*;
import org.openide.util.Utilities;
import org.openide.util.NbBundle;

import org.openide.src.nodes.SourceEditSupport.ExceptionalRunnable;

/** Customizer for FieldElement
 *
 * @author Petr Hamernik
 */
public class FieldCustomizer extends JPanel {
    /** Source of the localized human presentable strings. */
    static ResourceBundle bundle = NbBundle.getBundle(FieldCustomizer.class);

    /** The edited field */
    FieldElement element;

    /** Predefined types in the type combo */
    private static final String[] COMMON_TYPES = {
        "String", // NOI18N
        "boolean", // NOI18N
        "char", // NOI18N
        "int", // NOI18N
        "long", // NOI18N
        "byte", // NOI18N
        "short", // NOI18N
        "float", // NOI18N
        "double" // NOI18N
    };
    
    boolean isOK = true;

    /** Create new FieldCustomizer component
    * @param element The field to be customized
    */
    public FieldCustomizer(FieldElement element) {
        this.element = element;

        initComponents ();
        
        //borders
        nameTypePanel.setBorder (new CompoundBorder(
                                     new TitledBorder(bundle.getString("CTL_FieldFrame")),
                                     new EmptyBorder(new java.awt.Insets(5, 5, 5, 5)))
                                );
        modifierPanel.setBorder (new TitledBorder(bundle.getString("CTL_Modifiers")));
        initValuePanel.setBorder (new CompoundBorder(
                                      new TitledBorder(bundle.getString("CTL_InitValue")),
                                      new EmptyBorder(new java.awt.Insets(3, 3, 3, 3)))
                                 );


        // modifiers
        modifierPanel.add(ElementBeanModel.createModifiersPanel(element));

        // name
        nameTextField.setText(element.getName().toString());

        // type
        typeCombo.setSelectedItem(element.getType().toString());

        // init value
        initValueEditor.setText(element.getInitValue());

        //mnemonics
        jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        jLabel2.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0));
        initAccessibility();
    }

    public void addNotify() {
        super.addNotify();

        // select the name
        int l = nameTextField.getText().length();
        nameTextField.setCaretPosition(0);
        nameTextField.moveCaretPosition(l);
        nameTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        nameTypePanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        typeCombo = new javax.swing.JComboBox(COMMON_TYPES);
        jPanel1 = new javax.swing.JPanel();
        modifierPanel = new javax.swing.JPanel();
        initValuePanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        initValueEditor = new javax.swing.JEditorPane();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 6, 6, 6)));
        nameTypePanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints2;
        
        jLabel1.setText(bundle.getString("CTL_Name"));
        jLabel1.setLabelFor(nameTextField);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(10, 0, 0, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        nameTypePanel.add(jLabel1, gridBagConstraints2);
        
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new java.awt.Insets(10, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        nameTypePanel.add(nameTextField, gridBagConstraints2);
        
        jLabel2.setText(bundle.getString("CTL_Type"));
        jLabel2.setLabelFor(typeCombo);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(8, 0, 0, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        nameTypePanel.add(jLabel2, gridBagConstraints2);
        
        typeCombo.setEditable(true);
        typeCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new java.awt.Insets(8, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        nameTypePanel.add(typeCombo, gridBagConstraints2);
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.weighty = 1.0;
        nameTypePanel.add(jPanel1, gridBagConstraints2);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 1.0;
        add(nameTypePanel, gridBagConstraints1);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        add(modifierPanel, gridBagConstraints1);
        
        initValuePanel.setLayout(new java.awt.BorderLayout());
        
        initValueEditor.setPreferredSize(new java.awt.Dimension(302, 200));
        initValueEditor.setContentType("text/x-java"); // NOI18N
        initValueEditor.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                initValueEditorFocusLost(evt);
            }
        });
        
        jScrollPane1.setViewportView(initValueEditor);
        
        initValuePanel.add(jScrollPane1, java.awt.BorderLayout.CENTER);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(initValuePanel, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void jComboBox1ActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        Object selItem = typeCombo.getSelectedItem();
        Type oldValue = element.getType();
        boolean ok = false;
        
        if (selItem != null) {
            try {
                final Type newValue = Type.parse(selItem.toString());
                if (!oldValue.equals(newValue)) {
                    try {
                        SourceEditSupport.runAsUser(element, new ExceptionalRunnable() {
                            public void run() throws SourceException {
                                element.setType(newValue);
                            }
                        });
                        ok = true;
                    }
                    catch (SourceException e) {
                        ErrorManager.getDefault().notify(e);
                    }
                } else
                    return;
            }
            catch (IllegalArgumentException e) {
                ErrorManager.getDefault().annotate(
                    e, ErrorManager.USER, null, 
                    bundle.getString("MSG_Not_Valid_Type"),
                    null, null);
                ErrorManager.getDefault().notify(e);
            }
        }
        isOK = ok;
        if (!ok)
            typeCombo.setSelectedItem(oldValue.toString());
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void initValueEditorFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_initValueEditorFocusLost
        if (evt != null && evt.isTemporary())
            return;

        final String newText = initValueEditor.getText();
        String oldText = element.getInitValue();
        boolean ok = false;
        if (!newText.equals(oldText)) {
            try {
                SourceEditSupport.runAsUser(element, new ExceptionalRunnable() {
                    public void run() throws SourceException {
                        element.setInitValue(newText);
                    }
                });
                ok = true;
            }
            catch (SourceException e) {
                ErrorManager.getDefault().notify(e);
            }
        } else
            return;
        isOK = ok;
        if (!ok)
            initValueEditor.setText(oldText);
    }//GEN-LAST:event_initValueEditorFocusLost

    private void nameTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
        if (evt != null && evt.isTemporary())
            return;

        String newName = nameTextField.getText();
        String oldName = element.getName().toString();
        boolean ok = false;
        Exception x = null;

        if (Utilities.isJavaIdentifier(newName)) {
            if (!oldName.equals(newName)) {
                final Identifier id = Identifier.create(newName);
                try {
                    SourceEditSupport.runAsUser(element, new ExceptionalRunnable() {
                        public void run() throws SourceException {
                            element.setName(id);
                        }
                    });
                    ok = true;
                }
                catch (SourceException e) {
                    x = e;
                }
            } else
                return;
        } else {
            x = new IllegalArgumentException("Invalid name"); // NOI18N
            ErrorManager.getDefault().annotate(
                x, ErrorManager.USER, null, 
                bundle.getString("MSG_Not_Valid_Identifier"),
                null, null);
        }
        isOK = ok;
        if (!ok) {
            nameTextField.setText(oldName);
        }
        if (x != null) {
            ErrorManager.getDefault().notify(x);
        }
    }//GEN-LAST:event_nameTextFieldFocusLost


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel nameTypePanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JComboBox typeCombo;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel modifierPanel;
    private javax.swing.JPanel initValuePanel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JEditorPane initValueEditor;
    // End of variables declaration//GEN-END:variables

    private void initAccessibility() {
        nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_FieldNameTextField"));
        nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_FieldNameTextField"));
        initValueEditor.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_InitValueEditorPane"));
        initValueEditor.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_InitValueEditorPane"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_FieldCustomizerDialog"); // NOI18N
    }
    
    public boolean isOK() {
        nameTextFieldFocusLost(null);
        initValueEditorFocusLost(null);
        jComboBox1ActionPerformed(null);
        return isOK;
    }
    
}
