/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.nodes;

import org.openide.nodes.Node;
import org.openide.src.*;

/** A factory used to create
* instances of hierarchy node implementations.
* Loaders that use the element hierarchy
* should implement this factory
* so as to provide their own implementations of hierarchy element nodes.
* @see ClassChildren
* @see SourceChildren
*
* @author Dafe Simonek, Jaroslav Tulach
*/
public interface ElementNodeFactory {

    /** Make a node representing a constructor.
    * @param element the constructor
    * @return a constructor node instance
    */
    public Node createConstructorNode (ConstructorElement element);

    /** Make a node representing a method.
    * @param element the method
    * @return a method node instance
    */
    public Node createMethodNode (MethodElement element);

    /** Make a node representing a field.
    * @param element the field
    * @return a field node instance
    */
    public Node createFieldNode (FieldElement element);

    /** Make a node representing an initializer.
    * @param element the initializer
    * @return an initializer node instance
    */
    public Node createInitializerNode (InitializerElement element);

    /** Make a node representing a class.
    * @param element the class
    * @return a class node instance
    */
    public Node createClassNode (ClassElement element);

    /** Make a node indicating that the creation of children
    * is still under way.
    * It should be used when the process is slow.
    * @return a wait node
    */
    public Node createWaitNode ();

    /** Make a node indicating that there was an error creating
    * the element children.
    * @return the error node
    */
    public Node createErrorNode ();

}
