/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.nodes;

import java.lang.reflect.Modifier;

/* ? --jglick
* For convenience, implementations of this interface could use
* {@link Modifier} masks.
*/
/** Orders and filters members in a class element node.
* Can be used for methods, fields, inner classes, etc.
* <p>The semantics are very similar to those of <code>SourceElementFilter</code>.
* @see org.openide.src.ClassElement
* @see ClassChildren
*
* @author Dafe Simonek, Jan Jancura
*/
public class ClassElementFilter extends SourceElementFilter {
    // [PENDING] should initializers be included? --jglick

    /** Specifies a child representing a constructor. */
    public static final int     CONSTRUCTOR = 8;
    /** Specifies a child representing a field (instance variable). */
    public static final int     FIELD = 16;
    /** Specifies a child representing a method. */
    public static final int     METHOD = 32;
    /** Specifies a child representing the superclass of the node's class. */
    public static final int     EXTENDS = 64;
    /** Specifies a child representing an implemented interface of the node's class.
    * For a node representing an interface, this would specify an extended interface.
    */
    public static final int     IMPLEMENTS = 128;
    /** Does not specify a child type. */
    public static final int     ALL = SourceElementFilter.ALL | CONSTRUCTOR | FIELD | METHOD |
                                      EXTENDS | IMPLEMENTS;

    /** Default order and filtering.
    * Places all fields, constructors, methods, and inner classes (interfaces) together
    * in one block.
    */
    public static final int[]   DEFAULT_ORDER = {FIELD | CONSTRUCTOR | METHOD | CLASS | INTERFACE};

    // [PENDING] where is this used? --jglick
    /** Specifies a child which is static. */
    public static final int     STATIC = Modifier.STATIC;

    /** stores property value */
    private boolean             sorted = true;

    /** Test whether the elements in one element type group are sorted.
    * @return <code>true</code> if groups in getOrder () field are sorted, <code>false</code> 
    * to default order of elements
    */
    public boolean isSorted () {
        return sorted;
    }

    /** Set whether groups of elements returned by getOrder () should be sorted.
    * @param sorted <code>true</code> if so
    */
    public void setSorted (boolean sorted) {
        this.sorted = sorted;
    }
}
