/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.nodes;

import java.awt.BorderLayout;
import java.util.ResourceBundle;

import javax.swing.*;
import javax.swing.border.*;

import org.openide.src.*;
import org.openide.*;
import org.openide.util.Utilities;
import org.openide.util.NbBundle;

import org.openide.src.nodes.SourceEditSupport.ExceptionalRunnable;

/** Customizer for ClassElement
 *
 * @author Petr Hamernik
 */
public class ClassCustomizer extends JPanel {
    /** Source of the localized human presentable strings. */
    private static ResourceBundle bundle = NbBundle.getBundle(ClassCustomizer.class);

    /** Predefined types in the type combo */
    private static final String[] COMMON_TYPES = {
        "java.lang.Object", // NOI18N
        "java.awt.Component", // NOI18N
        "javax.swing.JComponent", // NOI18N
        "javax.swing.JPanel" // NOI18N
    };

    /** The edited class */
    ClassElement element;
    
    boolean isOK = true;
    
    /** Create new ClassCustomizer component
    * @param element The class to be customized
    */
    public ClassCustomizer(ClassElement element) {
        this.element = element;
        initComponents ();
        
        //borders
        classPanel.setBorder (new CompoundBorder(
                                  new TitledBorder(bundle.getString("CTL_ClassFrame")),
                                  new EmptyBorder(new java.awt.Insets(5, 5, 5, 5)))
                             );
        typePanel.setBorder (new TitledBorder(bundle.getString("CTL_ClassType")));
        modifierPanel.setBorder (new TitledBorder(bundle.getString("CTL_Modifiers")));
        interfacesPanel.setBorder (new TitledBorder(bundle.getString("CTL_Interfaces")));

        // modifiers
        modifierPanel.add(ElementBeanModel.createModifiersPanel(element), BorderLayout.CENTER);

        // class or interface, superclass
        ButtonGroup group = new ButtonGroup();
        group.add(classRadioButton);
        group.add(interfaceRadioButton);

        Identifier superclassId = element.getSuperclass();
        superClassCombo.setSelectedItem((superclassId == null) ? "" : superclassId.getFullName()); // NOI18N
        if (element.isClass()) {
            classRadioButton.setSelected(true);
        }
        else {
            interfaceRadioButton.setSelected(true);
            superClassCombo.setEnabled(false);
        }
        classRadioButton.setEnabled(false);
        interfaceRadioButton.setEnabled(false);

        // name
        nameTextField.setText(element.getName().getName());

        // interfaces
        interfacesPanel.add(
                ElementBeanModel.createPropertyPanel(element, ElementProperties.PROP_INTERFACES),
                BorderLayout.CENTER
        );

        //mnemonics
        jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        jLabel2.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0));
        
        initAccessibility();
    }

    public void addNotify() {
        super.addNotify();

        // select the name
        int l = nameTextField.getText().length();
        nameTextField.setCaretPosition(0);
        nameTextField.moveCaretPosition(l);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }
    
    /** This method is called from within the class to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        classPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        superClassCombo = new javax.swing.JComboBox(COMMON_TYPES);
        typePanel = new javax.swing.JPanel();
        classRadioButton = new javax.swing.JRadioButton();
        interfaceRadioButton = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        modifierPanel = new javax.swing.JPanel();
        interfacesPanel = new javax.swing.JPanel();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 6, 6, 6)));
        classPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints2;
        
        jLabel1.setText(bundle.getString("CTL_Name"));
        jLabel1.setLabelFor(nameTextField);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(12, 0, 0, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        classPanel.add(jLabel1, gridBagConstraints2);
        
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new java.awt.Insets(12, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        classPanel.add(nameTextField, gridBagConstraints2);
        
        jLabel2.setText(bundle.getString("CTL_Superclass"));
        jLabel2.setLabelFor(superClassCombo);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(8, 0, 0, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        classPanel.add(jLabel2, gridBagConstraints2);
        
        superClassCombo.setEditable(true);
        superClassCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                superClassComboActionPerformed(evt);
            }
        });
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new java.awt.Insets(8, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        classPanel.add(superClassCombo, gridBagConstraints2);
        
        typePanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints3;
        
        classRadioButton.setText(bundle.getString("CTL_Class"));
        classRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                switchClassAndInterface(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.insets = new java.awt.Insets(4, 8, 4, 4);
        typePanel.add(classRadioButton, gridBagConstraints3);
        
        interfaceRadioButton.setText(bundle.getString("CTL_Interface"));
        interfaceRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                switchClassAndInterface(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.insets = new java.awt.Insets(4, 4, 4, 8);
        typePanel.add(interfaceRadioButton, gridBagConstraints3);
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new java.awt.Insets(8, 0, 0, 0);
        gridBagConstraints2.weighty = 1.0;
        classPanel.add(typePanel, gridBagConstraints2);
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.VERTICAL;
        classPanel.add(jPanel3, gridBagConstraints2);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 1.0;
        add(classPanel, gridBagConstraints1);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(0, 5, 0, 0);
        add(modifierPanel, gridBagConstraints1);
        
        interfacesPanel.setLayout(new java.awt.BorderLayout());
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(interfacesPanel, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void superClassComboActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_superClassComboActionPerformed
        Identifier oldValue = element.getSuperclass();
        String oldValueStr = (oldValue == null) ? "" : oldValue.getFullName(); // NOI18N
	Object item = superClassCombo.getSelectedItem();

	if (item == null) {
	    // user held a CTRL -- bug in Swing ?!?
	    superClassCombo.setSelectedItem(oldValueStr);
	    return;
	}
        final String newValueStr = item.toString();
        boolean ok = false;
        try {
            if (!oldValueStr.equals(newValueStr)) {
                try {
                    SourceEditSupport.runAsUser(element,
                        new ExceptionalRunnable() {
                        public void run() throws SourceException {
                            element.setSuperclass(newValueStr.equals("") ? // NOI18N
                                                  null : Identifier.create(newValueStr)
                                                 );
                        }
                    });
                    ok = true;
                }
                catch (SourceException e) {
                    ErrorManager.getDefault().notify(e);
                }
            } else 
                return;
        }
        catch (IllegalArgumentException e) {
            ErrorManager.getDefault().annotate(
            e, ErrorManager.USER, null,
            bundle.getString("MSG_Not_Valid_Type"),
            null, null);
            ErrorManager.getDefault().notify(e);
        }
        isOK = ok;
        if (!ok)
            superClassCombo.setSelectedItem(oldValueStr);
    }//GEN-LAST:event_superClassComboActionPerformed

    private void switchClassAndInterface (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_switchClassAndInterface

    }//GEN-LAST:event_switchClassAndInterface

    private void nameTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
        if (evt != null && evt.isTemporary())
            return;

        String newName = nameTextField.getText();
        String oldName = element.getName().getName();
        boolean ok = false;
        Exception x = null;
        
        if (Utilities.isJavaIdentifier(newName)) {
            if (!oldName.equals(newName)) {
                final Identifier id = Identifier.create(newName);
                try {
                    SourceEditSupport.runAsUser(element,
                        new ExceptionalRunnable() {
                            public void run() throws SourceException {
                                element.setName(id);
                            }
                    });
                    ok = true;
                }
                catch (SourceException e) {
                    x = e;
                }
            } else
                return;
        } else {
            x = new IllegalArgumentException("Invalid name"); // NOI18N
            ErrorManager.getDefault().annotate(
                x, ErrorManager.USER, null, 
                bundle.getString("MSG_Not_Valid_Identifier"),
                null, null);
        }
        isOK = ok;
        if (!ok) {
            nameTextField.setText(oldName);
        }
        if (x != null)
            ErrorManager.getDefault().notify (x);
    }//GEN-LAST:event_nameTextFieldFocusLost


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel classPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JComboBox superClassCombo;
    private javax.swing.JPanel typePanel;
    private javax.swing.JRadioButton classRadioButton;
    private javax.swing.JRadioButton interfaceRadioButton;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel modifierPanel;
    private javax.swing.JPanel interfacesPanel;
    // End of variables declaration//GEN-END:variables

    
    private void initAccessibility() {
        nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ClassNameTextField"));
        nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClassNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_ClassCustomizerDialog"); // NOI18N
    }
    
    public boolean isOK() {
        superClassComboActionPerformed(null);
        nameTextFieldFocusLost(null);
        return isOK;
    }
}
