/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.beaninfo;

import java.beans.*;
import org.openide.explorer.propertysheet.editors.ModifierEditor;

import org.openide.src.*;

/**
* Bean info containing common information for all MemberElements (e.g. Fields, Methods,...)
*
* @author Petr Hamernik
*/
public class MemberElementBeanInfo extends SimpleBeanInfo implements ElementProperties {

    static String getString(String key) {
	return org.openide.util.NbBundle.getMessage(MemberElementBeanInfo.class, key);
    }
	    
    /**
     * Gets the beans <code>PropertyDescriptor</code>s.
     * 
     * @return An array of PropertyDescriptors describing the editable
     * properties supported by this bean.  May return null if the
     * information should be obtained by automatic analysis.
     */
    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor[] properties = new PropertyDescriptor[] {
                             new PropertyDescriptor(PROP_NAME, MemberElement.class, "getName", "setName"), // NOI18N
                             new PropertyDescriptor(PROP_MODIFIERS, MemberElement.class, "getModifiers", "setModifiers") // NOI18N
                         };
            properties[1].setPropertyEditorClass(ModifierEditor.class);
	    properties[0].setDisplayName(getString("PROP_MEMBER_NAME")); // NOI18N
	    properties[1].setDisplayName(getString("PROP_MEMBER_MODIFIERS")); // NOI18N
            return properties;
        } catch( IntrospectionException e) {
            return super.getPropertyDescriptors();
        }
    }

    /**
     * A bean may have a "default" property that is the property that will
     * mostly commonly be initially chosen for update by human's who are 
     * customizing the bean.
     * @return  Index of default property in the PropertyDescriptor array
     * 		returned by getPropertyDescriptors.
     * <P>	Returns -1 if there is no default property.
     */
    public int getDefaultPropertyIndex() {
        return 0;
    }
}
