/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.src.beaninfo;

import java.awt.Image;
import java.beans.*;
import org.openide.explorer.propertysheet.editors.IdentifierArrayEditor;

import org.openide.src.*;
import org.openide.util.Utilities;

/**
* Bean info for classes.
*
* @author Petr Hamernik
*/
public class ClassElementBeanInfo extends MemberElementBeanInfo {

    /**
    * Return the icon
    */
    public Image getIcon(int type) {
        return Utilities.loadImage("org/openide/src/resources/class.gif"); // NOI18N
    }


    /** @return Propertydescriptors */
    public PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] inh = super.getPropertyDescriptors();
        PropertyDescriptor[] desc = new PropertyDescriptor[inh.length + 3 + 3];
        System.arraycopy(inh, 0, desc, 0, inh.length);
        try {
            desc[inh.length] = new PropertyDescriptor(PROP_SUPERCLASS, ClassElement.class, "getSuperclass", "setSuperclass" ); // NOI18N
	    desc[inh.length].setDisplayName(getString("PROP_CLASS_SUPERCLASS")); // NOI18N
            desc[inh.length + 1] = new PropertyDescriptor(PROP_CLASS_OR_INTERFACE, ClassElement.class, "isClassOrInterface", "setClassOrInterface" ); // NOI18N
            desc[inh.length + 2] = new PropertyDescriptor(PROP_INTERFACES, ClassElement.class, "getInterfaces", "setInterfaces" ); // NOI18N
            desc[inh.length + 2].setPropertyEditorClass(IdentifierArrayEditor.class);
            desc[inh.length + 2].setValue("mnemonic_List", getString("MNEMO_CLASS_INTERFACES"));
	    desc[inh.length + 2].setValue("label_List", getString("LAB_CLASS_INTERFACES"));
            desc[inh.length + 3] = new PropertyDescriptor(PROP_FIELDS, ClassElement.class, "getFields", "setFields");
            desc[inh.length + 4] = new PropertyDescriptor(PROP_CONSTRUCTORS, ClassElement.class, "getConstructors", "setConstructors");
            desc[inh.length + 5] = new PropertyDescriptor(PROP_METHODS, ClassElement.class, "getMethods", "setMethods");
    	    desc[inh.length + 1].setDisplayName(getString("PROP_CLASS_IS_CLASS")); // NOI18N
    	    desc[inh.length + 2].setDisplayName(getString("PROP_CLASS_INTERFACES")); // NOI18N
            return desc;
        } catch (IntrospectionException ex) {
            return inh;
        }
    }
}
