/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.explorer.propertysheet.editors;

import java.util.ResourceBundle;
import java.awt.Dimension;
import java.util.Locale;

import org.openide.util.NbBundle;

/** Visual panel for editing one MethodParameter.
 *
 * @author Petr Hamernik
 */
class MethodParameterPanel extends javax.swing.JPanel {
    /** Resource bundle. */
    static final ResourceBundle bundle = NbBundle.getBundle("org.openide.explorer.propertysheet.editors.Bundle2", Locale.getDefault(), MethodParameterPanel.class.getClassLoader()); // NOI18N

    /** This array is used in type combo box. */
    static final String[] COMMON_TYPES = {
        "java.lang.String", // NOI18N
        "java.lang.Object", // NOI18N
        "boolean", // NOI18N
        "byte", // NOI18N
        "char", // NOI18N
      "short", // NOI18N
        "int", // NOI18N
      "long", // NOI18N
        "float", // NOI18N
        "double" // NOI18N
    };

    static final long serialVersionUID =5505625069203018340L;
    /** Creates new form ParamPanel */
    public MethodParameterPanel() {
        initComponents ();

        typeLabel.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0));
        nameLabel.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        finalCheckBox.setMnemonic(bundle.getString("CTL_Final_Mnemonic").charAt(0));

        getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MethodParameterPanel"));
        typeLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Type"));
        nameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Name"));
        finalCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Final"));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        typeLabel = new javax.swing.JLabel();
        typeCombo = new javax.swing.JComboBox(COMMON_TYPES);
        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        finalCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 0, 11)));
        setMinimumSize(new java.awt.Dimension(500, 87));
        typeLabel.setText(bundle.getString("CTL_Type"));
        typeLabel.setLabelFor(typeCombo);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 8);
        add(typeLabel, gridBagConstraints);

        typeCombo.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        add(typeCombo, gridBagConstraints);

        nameLabel.setText(bundle.getString("CTL_Name"));
        nameLabel.setLabelFor(nameTextField);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 8);
        add(nameLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        add(nameTextField, gridBagConstraints);

        finalCheckBox.setText(bundle.getString("CTL_Final"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.weightx = 1.0;
        add(finalCheckBox, gridBagConstraints);

    }//GEN-END:initComponents

    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + typeCombo.getPreferredSize().width, orig.height);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JLabel nameLabel;
    protected javax.swing.JLabel typeLabel;
    protected javax.swing.JCheckBox finalCheckBox;
    protected javax.swing.JTextField nameTextField;
    protected javax.swing.JComboBox typeCombo;
    // End of variables declaration//GEN-END:variables

}
