/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.explorer.propertysheet.editors;

import org.openide.src.ElementFormat;

/** Property editor for ElementFormat.
* TODO: - there should be also custom editor (for visual editing the format)
*
* @author   Petr Hamernik
*/
public class ElementFormatEditor extends java.beans.PropertyEditorSupport {

    /** Constructs new property editor. */
    public ElementFormatEditor() {
    }

    /**
    * @return The property value as a human editable string.
    */
    public String getAsText() {
        if ( getValue() == null )
            return "null"; // NOI18N
        else
            return ((ElementFormat)getValue()).getPattern();
    }

    /** Set the property value by parsing a given String.
    *
    * @param text The string to be parsed.
    * @exception IllegalArgumentException if the String is badly formatted.
    */
    public void setAsText(String text) throws IllegalArgumentException {
        setValue(new ElementFormat(text));
    }
}
