/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import org.openide.src.Type;
import java.util.Comparator;

class TypeComparator extends JavaElementComparator {

    private Comparator idComparator;    
    
    protected TypeComparator(int type) {
        super(type);
    }

    // this duplicate functionality of org.openide.src.Type because kind is private filed, and there is no access method  
    private static final int T_BOOLEAN  = 0x0001;
    private static final int T_INT      = 0x0002;
    private static final int T_CHAR     = 0x0003;
    private static final int T_BYTE     = 0x0004;
    private static final int T_SHORT    = 0x0005;
    private static final int T_LONG     = 0x0006;
    private static final int T_FLOAT    = 0x0007;
    private static final int T_DOUBLE   = 0x0008;
    private static final int T_VOID     = 0x0009;

    private static final int T_CLASS    = 0x0010;
    private static final int T_ARRAY    = 0x0020;
    
    private int getKind(Type t)
    {   if (t.isArray())
            return T_ARRAY;
        else if (t.isClass())
            return T_CLASS;
        else if (t==Type.BOOLEAN)
            return T_BOOLEAN;
        else if (t==Type.BYTE)
            return T_BYTE;
        else if (t==Type.CHAR)
            return T_CHAR;
        else if (t==Type.DOUBLE)
            return T_DOUBLE;
        else if (t==Type.FLOAT)
            return T_FLOAT;
        else if (t==Type.INT)
            return T_INT;
        else if (t==Type.LONG)
            return T_LONG;
        else if (t==Type.SHORT)
            return T_SHORT;
        else if (t==Type.VOID)
            return T_VOID;
        return 0; // nonsence kind
    }
    
    public int compare(Object o1, Object o2) {
        Type t1=(Type)o1;
        Type t2=(Type)o2;
        int t1_kind=getKind(t1);
        int t2_kind=getKind(t2);
        
        if (t1_kind!=t2_kind) {
            if (t1_kind>t2_kind) return 1;
            else return -1;
        }
        if (t1.isArray())
            return compare(t1.getElementType(),t2.getElementType());
        else if (t1.isClass()) {
            if (idComparator == null)
                idComparator=IdentifierComparator.createComparator(type);
            return idComparator.compare(t1.getClassName(),t2.getClassName());
        }
        else
            return 0;
    }       
    
    static Comparator createComparator(int type) {
        return new TypeComparator(type);
    }
    
}

