/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import java.util.Comparator;
import java.util.HashMap;
import java.lang.reflect.Method;
import org.openide.src.*;

public abstract class JavaElementComparator implements Comparator {

    protected int type;    
    private static HashMap element2comparator;
    
    /* comparator types */
    public static final int SOURCE = 1;
    public static final int RETURN_TYPE = 2;
    public static final int NAME = 4;
    public static final int PARAMETERS = 8;
    public static final int EXCEPTIONS = 16;
    public static final int TYPE = 32;
    public static final int MODIFIERS = 64;
    public static final int ISCLASS = 128;
    public static final int PARAM_NAME = 256;
    public static final int PARAM_MODIFIERS = 512;
    public static final int PARAM_TYPE = 1024;
    
    protected JavaElementComparator(int t) {
        type=t;
    }
    
    protected int getType() {
        return type;
    }

    public abstract int compare(Object o1, Object o2);

    public boolean equals(Object ob) {
        return getClass().isInstance(ob) && type==((JavaElementComparator)ob).getType();
    }
        
    public static Comparator createIdentifierComparator(boolean source) {
        return IdentifierComparator.createComparator(source?SOURCE:0);
    }

    public static Comparator createTypeComparator(boolean source) {
        return TypeComparator.createComparator(source?SOURCE:0);
    }
    
    public static Comparator createClassComparator(boolean source, int ordering[]) {
        return createComparator(ClassElement.class,source,ordering);
    }

    public static Comparator createConstructorComparator(boolean source, int ordering[]) {
        return createComparator(ConstructorElement.class,source,ordering);
    }

    public static Comparator createFiledComparator(boolean source, int ordering[]) {
        return createComparator(FieldElement.class,source,ordering);
    }

    public static Comparator createMParameterComparator(boolean source, int ordering[]) {
        return createComparator(MethodParameter.class,source,ordering);
    }

    public static Comparator createMethodComparator(boolean source, int ordering[]) {
        return createComparator(MethodElement.class,source,ordering);
    }

    public static Comparator createComparator(Object element,boolean source, int ordering[]) {
        return createComparator(element.getClass(),source,ordering);
    }
    
    public static Comparator createComparator(Class elementClass, boolean source, int ordering[]) {
        int i;
        int sourceType=source?SOURCE:0;
        Method createCompMethod;
        Comparator comparators[] = new Comparator[ordering.length];

        if (element2comparator==null) {
            synchronized (JavaElementComparator.class) {
                if (element2comparator == null)
                    createElementMap();
            }
        }
        createCompMethod=(Method)element2comparator.get(elementClass);
        if (createCompMethod==null)
            return null; // unsupported Class elementClass
        if (ordering==null || ordering.length==0) {
            try {
                Integer type=new Integer(sourceType);
                return (Comparator)createCompMethod.invoke(null,new Object[] {type});
            } catch (Exception ex) {
                org.openide.ErrorManager.getDefault().notify(org.openide.ErrorManager.WARNING, ex);
            }
            return null;
        }
        for (i=0;i<ordering.length;i++) {
            try {
                Integer type=new Integer(ordering[i]|sourceType);
                comparators[i]=(Comparator)createCompMethod.invoke(null,new Object[] {type});
            } catch (Exception ex) {
                org.openide.ErrorManager.getDefault().notify(org.openide.ErrorManager.WARNING, ex);
                return null;
            }
        }
        return new ArrayComparator(comparators);
    }
    
    private static void createElementMap() {
        Class args[] = new Class[] { Integer.TYPE };

        element2comparator=new HashMap();
        try {
            element2comparator.put(ClassElement.class,ClassComparator.class.getDeclaredMethod("createComparator",args)); // NOI18N
            element2comparator.put(ConstructorElement.class,ConstructorComparator.class.getDeclaredMethod("createComparator",args)); // NOI18N
            element2comparator.put(FieldElement.class,FieldComparator.class.getDeclaredMethod("createComparator",args)); // NOI18N
            element2comparator.put(Identifier.class,IdentifierComparator.class.getDeclaredMethod("createComparator",args)); // NOI18N
            element2comparator.put(MethodParameter.class,MParameterComparator.class.getDeclaredMethod("createComparator",args)); // NOI18N
            element2comparator.put(MethodElement.class,MethodComparator.class.getDeclaredMethod("createComparator",args)); // NOI18N
            element2comparator.put(Type.class,TypeComparator.class.getDeclaredMethod("createComparator",args)); // NOI18N
        } catch (NoSuchMethodException ex) {
            org.openide.ErrorManager.getDefault().notify(org.openide.ErrorManager.WARNING, ex);
        }
    }
    
}

