/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import org.openide.src.Identifier;
import java.util.Comparator;

class IdentifierComparator extends JavaElementComparator {

    protected IdentifierComparator(int type) {
        super(type);
    }    

    public int compare(Object o1, Object o2) {
        int result;
        Identifier id1=(Identifier)o1;
        Identifier id2=(Identifier)o2;

        result=id1.getFullName().compareTo(id2.getFullName());
        if (result!=0)
            return result;
        if ((type&SOURCE)!=0)
            return id1.getSourceName().compareTo(id2.getSourceName());
        return 0;
    }     
    
    static Comparator createComparator(int type) {
        return new IdentifierComparator(type);
    }
    
}

