/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import org.openide.src.ConstructorElement;
import org.openide.src.MethodParameter;
import org.openide.src.Identifier;
import java.util.Comparator;

class ConstructorComparator extends MemberNameComparator {
    protected Comparator idComparator;    
    protected Comparator paramComparator;
    
    protected ConstructorComparator(int type) {
        super(type);
        int source_type=type&SOURCE;
        int paramType = source_type;
        
        if ((type & PARAM_NAME) > 0)
            paramType |= NAME;
        if ((type & PARAM_MODIFIERS) > 0)
            paramType |= MODIFIERS;
        if ((type & PARAM_TYPE) > 0)
            paramType |= TYPE;
        
        if ((type&EXCEPTIONS)!=0) idComparator=IdentifierComparator.createComparator(source_type);
        if ((type&PARAMETERS)!=0) paramComparator=MParameterComparator.createComparator(paramType);
    }

    public int compare(Object o1, Object o2) {
        ConstructorElement ce1=(ConstructorElement)o1;
        ConstructorElement ce2=(ConstructorElement)o2;
        int result,i;

        if ((type&NAME)!=0) {
            result=super.compare(ce1,ce2);
            if (result!=0) return result;
        }
        if ((type&EXCEPTIONS)!=0) {
            Identifier[] excA = ce1.getExceptions();
            Identifier[] excB = ce2.getExceptions();

            if (excA.length != excB.length) {
                return excA.length-excB.length>0?1:-1;
            }
            for (i = 0; i < excA.length; i++) {
                result=idComparator.compare(excA[i],excB[i]);
                if (result!=0) return result;
            }
        }
        if (paramComparator!=null) {
            MethodParameter[] paramA = ce1.getParameters();
            MethodParameter[] paramB = ce2.getParameters();

            if (paramA.length != paramB.length) {
                return paramA.length-paramB.length>0?1:-1;
            }
            for (i = 0; i < paramA.length; i++) {
                result=paramComparator.compare(paramA[i],paramB[i]);
                if (result!=0) return result;
            }
        }
        return 0;
    }
        
    static Comparator createComparator(int type) {
        return new ConstructorComparator(type);
    }
    
}

