/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.java.comparators;

import java.util.Comparator;

/**
 *
 * @author  thurka
 * @version 
 */
class ArrayComparator extends Object implements Comparator {

    private Comparator comparators[];
    
    /** Creates new ArrayComparator */
    protected ArrayComparator(Comparator compArray[]) {
        comparators=compArray;
    }

    public int compare(Object o1, Object o2) {
        int i;
        
        for (i=0;i<comparators.length;i++) {
            int result=comparators[i].compare(o1,o2);
            
            if (result!=0)
                return result;
        }
        return 0;
    }

    public boolean equals(Object ob) {
        return getClass().isInstance(ob) && comparators.equals(((ArrayComparator)ob).getComparators());
    }
    
    public Comparator[] getComparators() {
        return comparators;
    }
}
