/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.java.ui.wizard;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.swing.event.ChangeListener;

import org.openide.ErrorManager;
import org.openide.WizardDescriptor;

import org.openide.filesystems.FileUtil;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.netbeans.api.java.classpath.ClassPath;

/**
 *
 * @author  builder
 */
class JavaPackageIterator implements TemplateWizard.Iterator {
    WizardDescriptor.Panel  targetChooser;
    TemplateWizard  wizardInstance;
    
    static TemplateWizard.Iterator create() {
        return new JavaPackageIterator();
    }
    
    public boolean hasNext() {
        return false;
    }
    
    public void previousPanel() {
        throw new NoSuchElementException();
    }
    
    public void removeChangeListener(ChangeListener l) {
    }
    
    public void addChangeListener(ChangeListener l) {
    }
    
    public String name() {
        return ""; //NOI18N
    }
    
    public void nextPanel() {
        throw new NoSuchElementException();
    }
    
    public boolean hasPrevious() {
        return false;
    }
    
    public WizardDescriptor.Panel current() {
        return wizardInstance.targetChooser();
    }
    
    public void initialize(TemplateWizard wiz) {
        wizardInstance = wiz;
    }
    
    public void uninitialize(TemplateWizard wiz) {
    }
    
    private void throwIllegalName(String key, String offending) throws IllegalStateException {
        String msg;
        if (offending == null) {
            msg = Util.getString(key);
        }
        else {
            msg = MessageFormat.format(Util.getString(key),
                new Object[] {
                offending});
        }

        IllegalStateException x = 
            (IllegalStateException)ErrorManager.getDefault().annotate(
        new IllegalStateException(msg),
        ErrorManager.USER, null, msg,
        null, null
        );
        throw x;
    }
    
    public java.util.Set instantiate(TemplateWizard wiz) throws IOException {
        DataFolder fld = wiz.getTargetFolder();
        FileObject fldFO = fld.getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath(fldFO,ClassPath.SOURCE);
        if (cp == null) {
            throwIllegalName("ERR_NotInSourcePath",null); // NOI18N
        }
        String s = cp.getResourceName(fldFO,'.',false);
        if (!Util.isValidPackageName(s)) {
            throwIllegalName("FMTERR_InvalidPackage", s); // NOI18N
        }
        String tn = wiz.getTargetName();
        if (tn == null) {
            // special handling for "package"
            tn = Util.getString("TXT_DefaultPackageName"); // NOI18N
        } else if (!Util.isValidPackageName(tn)) {
            throwIllegalName("FMTERR_InvalidPackage", tn); // NOI18N
        }

        s = s + '.' + tn;
        String pkgPath = s.replace('.', '/');
        
        // #37137: check if the package exists. TemplateWizard.targetChooser is not able to do that for 
        // a package hierarchy (a.b.c).
        FileObject target = cp.findResource(pkgPath);
        if (target != null && target.isFolder()) {
            throwIllegalName("FMTERR_pkg_already_exist", tn); // NOI18N
        }

        DataObject d = DataObject.find(
            FileUtil.createFolder(fldFO, tn.replace('.','/')));

        // get name of deepest subpackage
        s = d.getName();
        fld = d.getFolder();

        // magic to select package in explorer
        d = d.createFromTemplate(fld, s);

        return Collections.singleton(d);
    }
}
