/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import org.netbeans.jmi.javamodel.Method;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.nodes.Node;
import org.openide.src.ElementProperties;

import javax.jmi.reflect.InvalidObjectException;
import java.util.Map;
import java.util.HashMap;

/** Node for a method element.
 * @see org.netbeans.jmi.javamodel.Method
 * @author Petr Hamernik, Jan Pokorsky
 * XXX help ids
 */
public class MethodNode extends ElementNode {
    
    private static final Map mapAttributeName;
    
    static {
        mapAttributeName = new HashMap();
        mapAttributeName.put(PROP_MODIFIERS, PROP_MODIFIERS);
        mapAttributeName.put(ElementProperties.PROP_NAME, ElementProperties.PROP_NAME);
        mapAttributeName.put(PROP_PARAMETERS, PROP_PARAMETERS);
        mapAttributeName.put("typeName", PROP_RETURN); // NOI18N
        mapAttributeName.put("exceptionNames", PROP_EXCEPTIONS); // NOI18N
    }
    
    /** Create a new method node.
    * @param element method element to represent
    * @param writeable <code>true</code> to be writable
    */
    public MethodNode(Method element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        setElementFormat0(getElementFormatProperty());
        superSetName(element.getName());
    }

    protected String resolveIconBase() {
        return IconResolver.getIconBaseForMethod(getMethod());
    }

    protected ElementFormat getElementFormatProperty() {
        return getSourceOptions().getMethodElementFormat();
    }

    /* This method resolve the appropriate hint format for the type
    * of the element. It defines the short description.
    */
    protected ElementFormat getHintElementFormat() {
        return getSourceOptions().getMethodElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    /* Creates property set for this node */
    protected Sheet createSheet () {
        Sheet sheet = Sheet.createDefault();
        Node.Property[] props = new Node.Property[6];
        try {
            props[0] = createModifiersProperty(writeable);
            props[1] = createNameProperty(getMethod());
            props[2] = createTypeParametersProperty();
            props[3] = createParametersProperty(false);
            props[4] = createReturnProperty(writeable);
            props[5] = createExceptionsProperty(writeable);
            Sheet.Set ps = sheet.get(Sheet.PROPERTIES);
            ps.put(props);
        } catch (InvalidObjectException e) {
            // does not matter since class children will refresh its contents
        }
        return sheet;
    }
    
    private Node.Property createParametersProperty(boolean canW) {
        // this should be read-olny -> refactoring job
        Node.Property p = createParametersProperty(getMethod(), canW);
        p.setValue("changeImmediate" /* PropertyEnv.PROP_CHANGE_IMMEDIATE */,Boolean.FALSE); // NOI18N
        return p;
    }

    /** Create a node property for constructor exceptions.
    * @param canW <code>false</code> to force property to be read-only
    * @return the property
    */
    private Node.Property createExceptionsProperty(boolean canW) {
        Node.Property p = createExceptionsProperty(getMethod(), canW);
        p.setValue("changeImmediate" /* PropertyEnv.PROP_CHANGE_IMMEDIATE */,Boolean.FALSE); // NOI18N
        return p;
    }
    
    Node.Property createTypeParametersProperty() {
        Node.Property np = createTypeParametersProperty(PROP_TYPE_PARAMETERS, getMethod(), false);
        np.setValue("changeImmediate" /* PropertyEnv.PROP_CHANGE_IMMEDIATE */, Boolean.FALSE); // NOI18N
        return np;
    }

    /** Create a property for the method return value.
    * @param canW <code>false</code> to force property to be read-only
    * @return the property
    */
    private Node.Property createReturnProperty(boolean canW) {
        return createTypeProperty(PROP_RETURN, getMethod(), canW);
    }
    
    private Method getMethod() {
        return (Method) this.element;
    }
}
