/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.HashMap;

import org.openide.nodes.*;
import org.openide.src.ElementProperties;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

import javax.jmi.reflect.JmiException;

/** Node representing an initializer (static or nonstatic).
 * @see org.netbeans.jmi.javamodel.Initializer
 *
 * @author Petr Hamernik, Jan Pokorsky
 * 
 * XXX help ids
 */
public final class InitializerNode extends ElementNode {
    /** Return value of getIconAffectingProperties method. */
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[] {
                PROP_MODIFIERS
            };
    
    private static final Map mapAttributeName;
    
    static {
        mapAttributeName = new HashMap();
        mapAttributeName.put(PROP_MODIFIERS, PROP_MODIFIERS);
    }

    /** Create a new initializer node.
    * @param element initializer element to represent
    * @param writeable <code>true</code> to be writable
    */
    public InitializerNode(Initializer element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        setElementFormat0(getElementFormatProperty());
        superSetName("<initializer>"); // NOI18N
    }

    protected String resolveIconBase() {
        return IconResolver.getIconBaseForInitializer(getInitializer());
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    protected ElementFormat getElementFormatProperty() {
        return getSourceOptions().getInitializerElementFormat();
    }

    protected ElementFormat getHintElementFormat() {
        return getSourceOptions().getInitializerElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    protected Sheet createSheet () {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get(Sheet.PROPERTIES);
        ps.put(createStaticProperty(writeable));
        return sheet;
    }

    /** Indicate that this node cannot be renamed.
    * An initializer has no name.
    * @return <code>false</code>
    */
    public boolean canRename() {
        return false;
    }

    /** Create a property for whether or not the initializer is static.
    * @param canW <code>false</code> to force property to be read-only
    * @return the property
    */
    protected Node.Property createStaticProperty(boolean canW) {
        return new ElementNode.ElementProp(ElementProperties.PROP_STATIC, Boolean.TYPE, canW) {
                   /** Gets the value */
                   public Object getValue () {
                       return Modifier.isStatic(getInitializer().getModifiers())? Boolean.TRUE : Boolean.FALSE;
                   }

                   /** Sets the value */
                   public void setValue(final Object val) throws IllegalArgumentException,
                           IllegalAccessException, InvocationTargetException {
                       super.setValue(val);

                       if (!(val instanceof Boolean))
                           throw new IllegalArgumentException();
                       
                       boolean fail = true;
                       try {
                           JavaMetamodel.getDefaultRepository().beginTrans(true);
                           try {
                               int m = getInitializer().getModifiers();
                               
                               boolean oldV = Modifier.isStatic(m);
                               boolean newV = ((Boolean) val).booleanValue();
                               if (oldV == newV) {
                                   // no change
                               } else if (oldV) {
                                   m -= Modifier.STATIC;
                               } else {
                                   m += Modifier.STATIC;
                               }
                               
                               getInitializer().setModifiers(m);
                               fail = false;
                           } finally {
                               JavaMetamodel.getDefaultRepository().endTrans(fail);
                           }
                       } catch (JmiException ex) {
                           IllegalArgumentException iaex = new IllegalArgumentException();
                           iaex.initCause(ex);
                           throw iaex;
                       }
                   }
               };
    }
    
    private Initializer getInitializer() {
        return (Initializer) this.element;
    }
}
