/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *   
 *  You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *    
 *  The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 *  Microsystems, Inc. All Rights Reserved.
 *  
 */

package org.netbeans.modules.java.ui.nodes.elements;

import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.*;

/**
 *
 * @author Jan Becicka
 */
public class IconResolver implements IconStrings {
    
    private static String getIconBaseForMethod(int modif) {
        if (Modifier.isStatic(modif)) {
            // static method...
            if (Modifier.isPrivate(modif))
                return METHOD_ST_PRIVATE;
            else if (Modifier.isProtected(modif))
                return METHOD_ST_PROTECTED;
            else if (Modifier.isPublic(modif))
                return METHOD_ST_PUBLIC;
            else
                return METHOD_ST_PACKAGE;
        }
        else {
            // non-static method...
            if (Modifier.isPrivate(modif))
                return METHOD_PRIVATE;
            else if (Modifier.isProtected(modif))
                return METHOD_PROTECTED;
            else if (Modifier.isPublic(modif))
                return METHOD_PUBLIC;
            else
                return METHOD_PACKAGE;
        }
    }
    
    public static String getIconBaseForMethod(Method m) {
        return getIconBaseForMethod(m.getModifiers());
    }
    
    public static String getIconBaseForAttribute(Attribute a) {
        return getIconBaseForMethod(a.getModifiers());
    }
    
    public static String getIconBaseForVariable(Variable v) {
        return FIELD_PRIVATE;
    }
    
    public static String getIconBaseForField(Field f) {
        int modif = f.getModifiers();
        if (!Modifier.isStatic(modif)) {
            // non-static field...
            if (Modifier.isPrivate(modif))
                return FIELD_PRIVATE;
            else if (Modifier.isProtected(modif))
                return FIELD_PROTECTED;
            else if (Modifier.isPublic(modif))
                return FIELD_PUBLIC;
            else
                return FIELD_PACKAGE;
        }
        else {
            // static field...
            if (Modifier.isPrivate(modif))
                return FIELD_ST_PRIVATE;
            else if (Modifier.isProtected(modif))
                return FIELD_ST_PROTECTED;
            else if (Modifier.isPublic(modif))
                return FIELD_ST_PUBLIC;
            else
                return FIELD_ST_PACKAGE;
        }
    }
    
    public static String getIconBaseForInitializer(Initializer i) {
        return Modifier.isStatic(i.getModifiers())? INITIALIZER_ST : INITIALIZER;
    }
    
    public static String getIconBaseForJavaClass(JavaClass c) {
        return c.isInterface()? INTERFACE : CLASS;
    }

    public static String getIconBaseForConstructor(Constructor c) {
        int modif = c.getModifiers();
        if (Modifier.isPrivate(modif))
            return CONSTRUCTOR_PRIVATE;
        else if (Modifier.isProtected(modif))
            return CONSTRUCTOR_PROTECTED;
        else if (Modifier.isPublic(modif))
            return CONSTRUCTOR_PUBLIC;
        else
            return CONSTRUCTOR_PACKAGE;
    }
    
    public static String getIconBase(Feature f) {
        if (f instanceof Method)
            return getIconBaseForMethod((Method) f);
        if (f instanceof Field)
            return getIconBaseForField((Field) f);
        if (f instanceof Constructor)
            return getIconBaseForConstructor((Constructor) f);
        if (f instanceof Initializer)
            return getIconBaseForInitializer((Initializer) f);
        if (f instanceof JavaClass)
            return getIconBaseForJavaClass((JavaClass) f);
        if (f instanceof Attribute) 
            return getIconBaseForAttribute((Attribute) f);
        if (f instanceof AnnotationType)
            return ANNOTATION_TYPE;
        if (f instanceof EnumConstant)
            return ENUM_CONSTANT;
        if (f instanceof JavaEnum)
            return ENUM;
        throw new IllegalArgumentException("Unknown Feature"); // NOI18N
    }
}
