/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import java.lang.reflect.Modifier;
import java.awt.*;

import javax.swing.*;
import javax.jmi.reflect.JmiException;

import org.openide.*;
import org.openide.util.Utilities;
import org.openide.util.NbBundle;

import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.jmi.javamodel.*;

/** Customizer for FieldElement
 *
 * @author Petr Hamernik
 */
public final class FieldCustomizer extends JPanel {
    /** The edited field */
    private final Field element;
    private final JavaClass jclass;

    /** Predefined types in the type combo; 
     *  duplicate of {@link org.netbeans.modules.java.ui.nodes.editors.TypeEditor#LVALUE_TYPES} 
     */
    private static final String[] COMMON_TYPES = TypeEditor.LVALUE_TYPES; 
    
    private boolean isOK = true;

    /** Create new FieldCustomizer component
    * @param element The field to be customized
    */
    public FieldCustomizer(JavaClass jclass, Field element) {
        this.element = element;
        this.jclass = jclass;

        initComponents ();
        
        // modifiers
        int mask;
        if (jclass.isInterface()) {
            mask =  Modifier.PUBLIC | Modifier.STATIC | Modifier.FINAL;
        } else {
            mask = Modifier.PUBLIC | Modifier.PROTECTED | Modifier.PRIVATE |
                   Modifier.STATIC | Modifier.FINAL | Modifier.TRANSIENT |
                   Modifier.VOLATILE;
        }
        accessPanel.add(SourceEditSupport.createAccessModifiersPanel(element, mask), BorderLayout.CENTER);
        modifierPanel.add(SourceEditSupport.createOtherModifiersPanel(element, mask), BorderLayout.CENTER);

        // name
        nameTextField.setText(element.getName());

        // type
        typeCombo.setSelectedItem(ElementFormat.elementName(element.getType()));

        // init value
        initValueEditor.setText(element.getInitialValueText());

        //mnemonics
        jLabel1.setDisplayedMnemonic(NbBundle.getMessage(FieldCustomizer.class, "CTL_Name_Mnemonic").charAt(0)); // NOI18N
        jLabel2.setDisplayedMnemonic(NbBundle.getMessage(FieldCustomizer.class, "CTL_Type_Mnemonic").charAt(0)); // NOI18N
        jLabel5.setDisplayedMnemonic(NbBundle.getMessage(FieldCustomizer.class, "CTL_InitValue_Mnemonic").charAt(0)); // NOI18N
        initAccessibility();
    }

    public void addNotify() {
        super.addNotify();

        // select the name
        int l = nameTextField.getText().length();
        nameTextField.setCaretPosition(0);
        nameTextField.moveCaretPosition(l);
        nameTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                nameTextField.requestFocus();
            }
        });
    }
    
    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent(this.jclass);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        typeCombo = new javax.swing.JComboBox(COMMON_TYPES);
        jLabel3 = new javax.swing.JLabel();
        accessPanel = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        modifierPanel = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        initValuePanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        initValueEditor = new javax.swing.JEditorPane();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 6, 6, 6)));
        jLabel1.setLabelFor(nameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(jLabel1, gridBagConstraints);

        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 8, 0, 0);
        add(nameTextField, gridBagConstraints);
        nameTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "ACSD_FieldNameTextField"));

        jLabel2.setLabelFor(typeCombo);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Type"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel2, gridBagConstraints);

        typeCombo.setEditable(true);
        typeCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(typeCombo, gridBagConstraints);
        typeCombo.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "ACSD_FieldType"));

        jLabel3.setLabelFor(accessPanel);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_AccessRights"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel3, gridBagConstraints);

        accessPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(accessPanel, gridBagConstraints);

        jLabel4.setLabelFor(modifierPanel);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_Modifiers"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel4, gridBagConstraints);

        modifierPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(modifierPanel, gridBagConstraints);

        jLabel5.setLabelFor(initValueEditor);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(FieldCustomizer.class, "CTL_InitValue"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
        add(jLabel5, gridBagConstraints);

        initValuePanel.setLayout(new java.awt.BorderLayout());

        initValueEditor.setContentType("text/x-java");
        initValueEditor.setPreferredSize(new java.awt.Dimension(302, 200));
        initValueEditor.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                initValueEditorFocusLost(evt);
            }
        });

        jScrollPane1.setViewportView(initValueEditor);

        initValuePanel.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        add(initValuePanel, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void jComboBox1ActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        Object selItem = typeCombo.getSelectedItem();
        if (selItem == null)
           return;
        
        String selItemTxt = selItem.toString().trim();
        Type oldValue = element.getType();
        boolean ok = false;
        
        try {
            final Type newValue = getJModel().getType().resolve(selItemTxt);
            if (oldValue.equals(newValue)) {
                return; // nothing to change
            } else if (!TypeEditor.isValidTypeSyntax(selItemTxt)) {
                notifyUserWarning("MSG_Not_Valid_Type", "invalid type"); // NOI18N
            } else if (newValue instanceof PrimitiveType &&
                    PrimitiveTypeKindEnum.VOID.equals(((PrimitiveType) newValue).getKind())) {
                notifyUserWarning("MSG_Not_Valid_Type", "invalid type"); // NOI18N
            } else {
                element.setType(newValue);
                ok = true;
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(e);
        }
        isOK = ok;
        if (!ok)
            typeCombo.setSelectedItem(ElementFormat.elementName(oldValue));
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void initValueEditorFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_initValueEditorFocusLost
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent())))
            return;

        String newText = initValueEditor.getText();
        String oldText = element.getInitialValueText(); 
        boolean ok = false;
        if (!newText.equals(oldText)) {
            try {
                element.setInitialValueText(newText);
                ok = true;
            } catch (JmiException e) {
                ErrorManager.getDefault().notify(e);
            }
        } else
            return;
        isOK = ok;
        if (!ok)
            initValueEditor.setText(oldText);
    }//GEN-LAST:event_initValueEditorFocusLost

    private void nameTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent())))
            return;

        String newName = nameTextField.getText().trim();
        String oldName = element.getName();
        boolean ok = false;

        try {
            if (!Utilities.isJavaIdentifier(newName)) {
                notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name"); // NOI18N);
            } else if (oldName.equals(newName)) {
                return; // nothing to change
            } else if (this.jclass.getField(newName, true) != null) {
                notifyUserWarning("MSG_Used_Identifier", newName, "invalid name"); // NOI18N);
            } else {
                element.setName(newName);
                ok = true;
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(e);
        }
        isOK = ok;
        if (!ok) {
            nameTextField.setText(oldName);
        }
    }//GEN-LAST:event_nameTextFieldFocusLost


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel accessPanel;
    private javax.swing.JEditorPane initValueEditor;
    private javax.swing.JPanel initValuePanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel modifierPanel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JComboBox typeCombo;
    // End of variables declaration//GEN-END:variables

    private void initAccessibility() {
        nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizer.class, "ACS_FieldNameTextField")); // NOI18N
        nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, "ACS_FieldNameTextField")); // NOI18N
        initValueEditor.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizer.class, "ACSN_InitValueEditorPane")); // NOI18N
        initValueEditor.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, "ACSD_InitValueEditorPane")); // NOI18N
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, "ACSD_FieldCustomizerDialog")); // NOI18N
    }
    
    public boolean isOK() {
        nameTextFieldFocusLost(null);
        if (isOK) {
            initValueEditorFocusLost(null);
        }
        if (isOK) {
            jComboBox1ActionPerformed(null);
        }
        return isOK;
    }
    
    private static void notifyUserWarning(String bundleKey, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg); // NOI18N
        ErrorManager.getDefault().annotate(
            e, ErrorManager.USER, null, 
            NbBundle.getMessage(FieldCustomizer.class, bundleKey),
            null, null);
        ErrorManager.getDefault().notify(e);

    }
    
    private static void notifyUserWarning(String bundleKey, String param, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate(
            e, ErrorManager.USER, null, 
            NbBundle.getMessage(FieldCustomizer.class, bundleKey, param),
            null, null);
        ErrorManager.getDefault().notify(e);
    }
    
}
