/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.NewType;
import org.openide.src.ElementProperties;
import org.netbeans.jmi.javamodel.JavaEnum;

import java.util.Map;
import java.util.HashMap;

/**
 * Node representing an enumeration
 * @see org.netbeans.jmi.javamodel.JavaEnum
 */
public final class EnumNode extends ElementNode {

    private static final Map mapAttributeName;
    
    static {
        mapAttributeName = new HashMap();
        mapAttributeName.put(PROP_MODIFIERS, PROP_MODIFIERS);
        mapAttributeName.put(ElementProperties.PROP_NAME, ElementProperties.PROP_NAME);
        mapAttributeName.put("interfaceNames", PROP_INTERFACES); // NOI18N
    }
    
    public EnumNode(JavaEnum element, Children children, boolean writeable) {
        super(element, children, writeable);
        setElementFormat0(getElementFormatProperty());
    }

    protected String resolveIconBase() {
        return IconStrings.ENUM;
    }

    protected ElementFormat getElementFormatProperty() {
        return getSourceOptions().getEnumElementFormat();
    }

    protected ElementFormat getHintElementFormat() {
        return getSourceOptions().getEnumElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    public NewType[] getNewTypes() {
        if (writeable) {
            return SourceEditSupport.createEnumNewTypes(getEnum());
        } else {
            return super.getNewTypes();
        }
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ps = s.get(Sheet.PROPERTIES);
        ps.put(createModifiersProperty(writeable));
        ps.put(createNameProperty(getEnum()));
        ps.put(createInterfacesProperty(writeable));
        return s;
    }

    /** Create a node property for the implemented interfaces of this class.
    * (Or, extended interfaces if this is itself an interface.)
    * @param canW if <code>false</code>, property will be read-only
    * @return the property
    */
    private Node.Property createInterfacesProperty(boolean canW) {
        Node.Property prop = ClassNode.createInterfacesProperty(getEnum(), canW); 

        prop.setValue("changeImmediate" /* PropertyEnv.PROP_CHANGE_IMMEDIATE */, Boolean.FALSE); // NOI18N
        setModel(getEnum(), prop);
        
        return prop;
    }
    
    private JavaEnum getEnum() {
        return (JavaEnum) this.element;
    }
}
