/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.elements;

import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.ErrorManager;

import javax.jmi.reflect.JmiException;

/**
 * Customizer for {@link org.netbeans.jmi.javamodel.EnumConstant}
 * @author  Jan Pokorsky
 */
final class EnumConstantCustomizer extends javax.swing.JPanel {
    
    /** Declaring enum */
    private final JavaEnum jclass;
    /** The edited constant */
    private EnumConstant constant;
    private boolean isOK = true;
    
    /** Creates new form EnumConstantCustomizer */
    public EnumConstantCustomizer(JavaEnum jclass, EnumConstant constant) {
        this.jclass = jclass;
        this.constant = constant;
        initComponents();
        
        nameTextField.setText(constant.getName());
        HelpCtx.setHelpIDString (this, "java.enumconstant.customizer"); // NOI18N
        
        initAccessibility();
    }

    public boolean isOK() {
        nameTextFieldFocusLost(null);
        return isOK;
    }
    
    private void initAccessibility() {
        nameTextField.getAccessibleContext().setAccessibleName(getString("ACSN_ConstantNameTextField")); // NOI18N
        nameTextField.getAccessibleContext().setAccessibleDescription(getString("ACSD_ConstantNameTextField")); // NOI18N
        this.getAccessibleContext().setAccessibleDescription("ACSD_ConstantCustomizerDialog"); // NOI18N
    }
    
    /** I18N helper */
    private static String getString(String key) {
        return NbBundle.getMessage(EnumConstantCustomizer.class, key);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        nameLabel.setLabelFor(nameTextField);
        nameLabel.setText(org.openide.util.NbBundle.getMessage(EnumConstantCustomizer.class, "CTL_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 8);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(nameLabel, gridBagConstraints);

        nameTextField.setColumns(25);
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 11);
        gridBagConstraints.weightx = 1.0;
        add(nameTextField, gridBagConstraints);

    }//GEN-END:initComponents

    private void nameTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent())))
            return;

        String newName = nameTextField.getText().trim();
        String oldName = constant.getName();
        boolean ok = false;
        Exception x = null;

        if (!Utilities.isJavaIdentifier(newName)) {
            x = new IllegalArgumentException("Invalid name"); // NOI18N
            ErrorManager.getDefault().annotate(
                    x, ErrorManager.USER, null, 
                    NbBundle.getMessage(FieldCustomizer.class, "MSG_Not_Valid_Identifier"), // NOI18N
                    null, null);
        } else if (oldName.equals(newName)) {
            return; // nothing to change
        } else if (SourceEditSupport.findConstant(this.jclass, newName) != null) {
            x = new IllegalArgumentException("Invalid name"); // NOI18N
            ErrorManager.getDefault().annotate(
                    x, ErrorManager.USER, null,
                    NbBundle.getMessage(FieldCustomizer.class, "MSG_Used_Identifier", newName), // NOI18N
                    null, null);
        } else {
            try {
                constant.setName(newName);
                ok = true;
            } catch (JmiException e) {
                ErrorManager.getDefault().notify(e);
            }
        }
        isOK = ok;
        if (!ok) {
            nameTextField.setText(oldName);
        }
        if (x != null) {
            ErrorManager.getDefault().notify(x);
        }
    }//GEN-LAST:event_nameTextFieldFocusLost
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTextField;
    // End of variables declaration//GEN-END:variables
    
}
