/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.openide.nodes.Node;

import javax.jmi.reflect.JmiException;
import java.util.Collection;
import java.util.List;
import java.util.Iterator;
import java.util.LinkedList;

/**
 * implementation of children list for a annotation type node
 */
public final class AnnotationTypeChildren extends ClassChildren {
    
    public AnnotationTypeChildren(SourceNodeFactory factory, AnnotationType element) {
        super(factory, element);
    }

    protected Node[] createNodesImpl(Object key) throws JmiException {
        if (key instanceof Attribute) {
            Attribute a = (Attribute) key;
            hookNodeName(a);
            return new Node[] { getFactory().createAnnotationTypeMethodNode(a) };
        }
        return super.createNodesImpl(key);
    }

    protected List getKeysOfType(Collection/*<ClassMemeber>*/ elements, int elementType) {
        List keys;
        if ((elementType & AnnotationTypeFilter.MEMBER) != 0) {
            keys = new LinkedList();
            for (Iterator it = elements.iterator(); it.hasNext();) {
                Object member = it.next();
                if ((elementType & AnnotationTypeFilter.MEMBER) != 0 && member instanceof Attribute) {
                    keys.add(member);
                }
            }
        } else {
            keys = super.getKeysOfType(elements, elementType);
        }
        
        return keys;
    }

    protected void refreshAllKeys() {
        refreshKeys(AnnotationTypeFilter.ALL);
    }

    protected int[] getOrder() {
        return (filter == null || (filter.getOrder() == null))
               ? AnnotationTypeFilter.DEFAULT_ORDER : filter.getOrder();
    }
}
