/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.editors;

import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

import javax.jmi.reflect.JmiException;
import java.beans.PropertyEditorSupport;

/** Property editor for array of {@link org.netbeans.jmi.javamodel.TypeParameter} class
 *
 * @author Jan Pokorsky
 */
public final class TypeParameterArrayEditor extends PropertyEditorSupport implements ExPropertyEditor {
    
    private JavaModelPackage model;
    
    public String getAsText() {
        TypeParameter[] tps = (TypeParameter[]) getValue();
        StringBuffer text = new StringBuffer();
        
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                for (int i = 0; i < tps.length; i++) {
                    TypeParameter tp = tps[i];
                    if (i > 0) {
                        text.append(", "); // NOI18N
                    }
                    text.append(param2String(tp));
                }
            } finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(e);
        }
        return text.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public static String params2String(TypeParameter[] params, String delimiter) {
        StringBuffer buf = new StringBuffer(30);
        for (int i = 0; i < params.length; i++) {
            if (i > 0)
                buf.append(delimiter); // NOI18N
            buf.append(param2String(params[i]));
        }
        return buf.toString();
    }
    
    private static String param2String(TypeParameter tp) {
        int start = tp.getStartOffset();
        int end = tp.getEndOffset();
        return tp.getResource().getSourceText().substring(start, end);
    }
    
    public void attachEnv(PropertyEnv env) {
        model = ElementNode.getModel(env.getFeatureDescriptor());
    }
}
