/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes.editors;

import java.util.ResourceBundle;
import java.awt.Dimension;

import org.openide.util.NbBundle;

/** Visual panel for editing one MethodParameter.
 *
 * @author Petr Hamernik
 */
class MethodParameterPanel extends javax.swing.JPanel {
    /** Resource bundle. */
    static final ResourceBundle bundle = NbBundle.getBundle(MethodParameterPanel.class);

    /** This array is used in type combo box. */
    static final String[] COMMON_TYPES = TypeEditor.LVALUE_TYPES; 

    /** Creates new form ParamPanel */
    public MethodParameterPanel() {
        initComponents ();

        typeLabel.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0)); // NOI18N
        nameLabel.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0)); // NOI18N
        finalCheckBox.setMnemonic(bundle.getString("CTL_Final_Mnemonic").charAt(0)); // NOI18N

        getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MethodParameterPanel")); // NOI18N
        typeLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Type")); // NOI18N
        nameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Name")); // NOI18N
        finalCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Final")); // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        typeLabel = new javax.swing.JLabel();
        typeCombo = new javax.swing.JComboBox(COMMON_TYPES);
        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        finalCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 0, 11)));
        setMinimumSize(new java.awt.Dimension(500, 87));
        typeLabel.setText(bundle.getString("CTL_Type"));
        typeLabel.setLabelFor(typeCombo);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 8);
        add(typeLabel, gridBagConstraints);

        typeCombo.setEditable(true);
        typeCombo.setSelectedItem(TypeEditor.LVALUE_TYPES[TypeEditor.LVALUE_TYPES.length-1]);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        add(typeCombo, gridBagConstraints);

        nameLabel.setText(bundle.getString("CTL_Name"));
        nameLabel.setLabelFor(nameTextField);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 8);
        add(nameLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        add(nameTextField, gridBagConstraints);

        finalCheckBox.setText(bundle.getString("CTL_Final"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.weightx = 1.0;
        add(finalCheckBox, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + typeCombo.getPreferredSize().width, orig.height);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JLabel nameLabel;
    protected javax.swing.JLabel typeLabel;
    protected javax.swing.JCheckBox finalCheckBox;
    protected javax.swing.JTextField nameTextField;
    protected javax.swing.JComboBox typeCombo;
    // End of variables declaration//GEN-END:variables

}
