/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes;

import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;

import java.text.Format;

/**
 * Helper class that simplifies work with source nodes.
 */
public final class SourceNodes {
    
    private static SourceNodeFactory BROWSER_FACTORY;
    private static SourceNodeFactory EXPLORER_FACTORY;
    
    public static SourceNodeFactory getExplorerFactory() {
        if (EXPLORER_FACTORY == null) {
            EXPLORER_FACTORY = createSourceNodeFactory(
                    (ExElementNodeFactory) JavaDataObject.getExplorerFactory()); 
        }
        return EXPLORER_FACTORY;
    }
    
    public static SourceNodeFactory getBrowserFactory() {
        if (BROWSER_FACTORY == null) {
            JavaSourceNodeFactory f = new JavaSourceNodeFactory();
            f.setGenerateForTree(true);
            BROWSER_FACTORY = f;
        }
        return BROWSER_FACTORY;
    }
    
    /**
     * helper that allows to use {@link SourceNodeFactory} as {@link org.openide.src.nodes.ElementNodeFactory} 
     * @param factory jmi nodes factory
     * @return srcmodel nodes factory
     */ 
    public static ExElementNodeFactory createElementNodeFactory(SourceNodeFactory factory) {
        return new BridgeSource2Element(factory);
    }
    
    /**
     * helper that allows to use {@link org.openide.src.nodes.ElementNodeFactory} as {@link SourceNodeFactory}  
     * @param factory srcmodel nodes factory
     * @return jmi nodes factory
     */ 
    public static SourceNodeFactory createSourceNodeFactory(ExElementNodeFactory factory) {
        return new BridgeElement2Source(factory);
    }

    /**
     * creates format for jmi elements
     * @param pattern pattern
     * @return the format
     */ 
    public static Format createElementFormat(String pattern) {
        return new ElementFormat(pattern);
    }

}
