/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes;

import org.openide.nodes.Node;
import org.netbeans.jmi.javamodel.*;

public class FilterSourceNodeFactory implements SourceNodeFactory {
    
    private SourceNodeFactory delegate;
    
    public final void attach(SourceNodeFactory factory) {
        if (factory == null) throw new NullPointerException("factory"); // NOI18N
        this.delegate = factory;
    }
    
    public Node createConstructorNode(Constructor element) {
        return delegate.createConstructorNode(element);
    }

    public Node createMethodNode(Method element) {
        return delegate.createMethodNode(element);
    }

    public Node createFieldNode(Field element) {
        return delegate.createFieldNode(element);
    }

    public Node createInitializerNode(Initializer element) {
        return delegate.createInitializerNode(element);
    }

    public Node createClassNode(JavaClass element) {
        return delegate.createClassNode(element);
    }

    public Node createEnumNode(JavaEnum element) {
        return delegate.createEnumNode(element);
    }

    public Node createEnumConstantNode(EnumConstant element) {
        return delegate.createEnumConstantNode(element);
    }

    public Node createAnnotationTypeNode(AnnotationType element) {
        return delegate.createAnnotationTypeNode(element);
    }

    public Node createAnnotationTypeMethodNode(Attribute element) {
        return delegate.createAnnotationTypeMethodNode(element);
    }

    public Node createWaitNode() {
        return delegate.createWaitNode();
    }

    public Node createErrorNode() {
        return delegate.createErrorNode();
    }
}
