/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.nodes;

import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FilterFactory;
import org.openide.src.*;
import org.openide.nodes.Node;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Attribute;

/**
 * extended {@link FilterFactory} to support jdk1.5 features
 */
public final class ExFilterFactory implements ExElementNodeFactory {
    
    private ExElementNodeFactory delegate;
    private final ElementNodeFactory impl;
    
    private ExFilterFactory() {
        this.impl = null;
    }
    
    public ExFilterFactory(ElementNodeFactory f) {
        this.impl = f;
    }
    
    public void attach(ExElementNodeFactory f) {
        if (!(impl instanceof FilterFactory)) {
            throw new UnsupportedOperationException();
        }
        ((FilterFactory) impl).attachTo(f);
        this.delegate = f;
    }
    
    public Node createEnumNode(JavaEnum element) {
        checkAttached();
        return delegate.createEnumNode(element);
    }

    public Node createEnumConstantNode(EnumConstant element) {
        checkAttached();
        return delegate.createEnumConstantNode(element);
    }

    public Node createAnnotationTypeNode(AnnotationType element) {
        checkAttached();
        return delegate.createAnnotationTypeNode(element);
    }

    public Node createAnnotationTypeMethodNode(Attribute element) {
        checkAttached();
        return delegate.createAnnotationTypeMethodNode(element);
    }

    public Node createClassNode(ClassElement element) {
        return impl.createClassNode(element);
    }

    public Node createConstructorNode(ConstructorElement element) {
        return impl.createConstructorNode(element);
    }

    public Node createErrorNode() {
        return impl.createErrorNode();
    }

    public Node createFieldNode(FieldElement element) {
        return impl.createFieldNode(element);
    }

    public Node createInitializerNode(InitializerElement element) {
        return impl.createInitializerNode(element);
    }

    public Node createMethodNode(MethodElement element) {
        return impl.createMethodNode(element);
    }

    public Node createWaitNode() {
        return impl.createWaitNode();
    }

    private void checkAttached() throws IllegalStateException {
        if (delegate == null) {
            throw new IllegalStateException("factory is not attached"); // NOI18N
        }
    }
}
