/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.ui.editors;

import java.beans.*;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;


import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;


import org.openide.src.*;

/**
 * A specialized PropertyEditor for {@link org.openide.src.Identifier} data type
 * for type name selection. The property editor can be further customized or
 * constrained by various atributes in the FeatureDescriptor for the given property.
 *
 * @author  sdedic
 * @version
 */
public class TypeIdentPE extends PropertyEditorSupport implements ExPropertyEditor {

    private static final String ATTR_CUSTOM_TITLE  = "title"; // NOI18N
    private static final String ATTR_CUSTOM_INPUT = "userInput"; // NOI18N
    private static final String ATTR_CLASSPATH_ROOTS = "classPathRoots"; // NOI18N
    private static final String ATTR_ACCEPT_CLASSES = "acceptClasses"; // NOI18N
    private static final String ATTR_ACCEPT_INTERFACES = "acceptInterfaces"; // NOI18N
    private static final String ATTR_DATA_FILTER = "dataFilter"; // NOI18N
    
    /**
     * Environment for the property editor.
     */
    PropertyEnv             environment;
    
    /**
     * True, if a class name can be entered. Default = <CODE>true</CODE>
     */
    boolean                 acceptClasses = true;
    
    /**
     * True, if an interface name can be entered. Default = <CODE>true</CODE>
     */
    boolean                 acceptInterfaces = true;
    
    /**
     * True, if only validated input should be accepted. Unknown names
     * are treated as invalid in that case. Default = <CODE>false</CODE>
     */
    boolean                 validNamesOnly = false;
    
    PropertyChangeSupport   supp;
    
    ClassChooserPanel       customEditor;
    
    /**
     * Custom acceptor for values presented by the property editor.
    PropertyValueAcceptor   valueAcceptor;
     */
    
    /**
     * The value itself.
     */
    Identifier              identifier;
    
    public java.lang.String getAsText() {
        if (identifier == null)
            return ""; // NOI18N
        
        // return the source form of the identifier.
        return identifier.getSourceName();
    }
    
    /**
     * Accepts a single class or interface name - depending on the feature
     * descriptor passed.
     * @param str name of a class, or an interface, or an empty string.
     *
     * @throw IllegalArgumentException if
     * <UL>
     * <LI><STRONG>str</STRONG> is not a valid Java identifier
     * <LI><STRONG>str</STRONG> identifies a class although the Editor was
     * instructed to accept only interfaces or vice versa.
     * </UL>
     */
    public void setAsText(java.lang.String str) throws IllegalArgumentException {
        Identifier i;
        
        if (str == null || "".equals(str)) {
            i = null;
        } else {
            Type t;

            // try to parse the type. This can throw IllegalArgumentException,
            // if the string does not form a valid java type specification.
            t = Type.parse(str);

            // if primitive or array type, deny the input (IAE)
            if (t.isPrimitive()) {
                denyPrimitiveType(t);
            } else if (t.isArray()) {
                denyArrayType(t);
            }

            ClassElement c = loadRepresentation(str);

            // checks constraints imposed on this property editor and
            // throws IAE if necessary
            checkInputConstraints(str, c);
            
            i = t.getClassName();
        }        

        // record the new value & fire a property change.
        super.setValue(i);
    }

    public void setValue(java.lang.Object obj) throws IllegalArgumentException {
        if (!(obj instanceof Identifier))
            throw new IllegalArgumentException("Invalid value type: " + obj.getClass()); // NOI18N
        super.setValue(obj);
    }

    /**
     * Does not support a custom property editor (yet)
     */
    public boolean supportsCustomEditor() {
        return true;
    }
    
    /**
     * Attaches itself to a PropertyEnv. The implementation scans for
     * some attributes and sets the editor's properties according to them.
     * <UL>
     * <LI>{@link #ATTR_ACCEPT_CLASSES} for acceptClasses property
     * <LI>{@link #ATTR_ACCEPT_INTEFACES} for acceptInterfaces property
     * </UL>
     */
    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor fd = env.getFeatureDescriptor();
        
        Boolean b;
        
        b = (Boolean)fd.getValue(ATTR_ACCEPT_CLASSES);
        if (b != null)
            setAcceptClasses(b.booleanValue());

        b = (Boolean)fd.getValue(ATTR_ACCEPT_INTERFACES);
        if (b != null)
            setAcceptInterfaces(b.booleanValue());
        
        /*
        Object filter = ds.getValue(ATTR_DATA_FILTER);
        if (filter instanceof PropertyValueAcceptor) {
            acceptor = (PropertyValueAcceptor)filter;
        }
         */
    }
    
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        if (supp == null) {
            synchronized (this) {
                if (supp == null)
                    supp = new PropertyChangeSupport(this);
            }
        }
        synchronized (supp) {
            supp.addPropertyChangeListener(l);
        }
    }
    
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (supp != null) {
            synchronized (supp) {
                supp.removePropertyChangeListener(l);
            }
        }
        super.removePropertyChangeListener(l);
    }
    
    void enableOK(boolean enable) {
        if (supp == null) {
            return;
        }
        supp.firePropertyChange(ExPropertyEditor.PROP_VALUE_VALID, null, 
            enable ? Boolean.TRUE : Boolean.FALSE);
    }
    
    /**
     * Configures the Editor so that it accepts class names.
     * This can be combined with {@link #setAcceptInterfaces} to allow both
     * interface and class names to be entered.
     */
    public void setAcceptClasses(boolean accept) {
        this.acceptClasses = accept;
    }
    
    /**
     * Configures the Editor so that it accepts interface names.
     * This can be combined with {@link #setAcceptClasses} to allow both
     * interface and class names to be entered.
     */
    public void setAcceptInterfaces(boolean accept) {
        this.acceptInterfaces = accept;
    }
    
    public void setValidNamesOnly(boolean accept) {
        this.validNamesOnly = accept;
    }
    
    public boolean getAcceptClasses() {
        return this.acceptClasses;
    }
    
    public boolean getAcceptInterfaces() {
        return this.acceptInterfaces;
    }
    
    public boolean getValidNamesOnly() {
        return this.validNamesOnly;
    }
    
    /*
     * The boring non-UI stuff...
     */
    
    /**
     * This method tries to locate a class, given the user-supplied className.
     * Note that because resolver functions are absent, it can't get any context
     * information. Pity.
     */
    private ClassElement loadRepresentation(String className) {
        //TODO: !!!!! Don't know what to do with this
        return ClassElement.forName(className);
    }
    
    
    private void denyPrimitiveType(Type t) {
        throw new IllegalArgumentException(
            t.toString() + " is a primitive type. Simple class or interface is required" // NOI18N
        );
    }
    
    private void denyArrayType(Type t) {
        throw new IllegalArgumentException(
            t.toString() + " is an array. Simple class or interface is required" // NOI18N
        );
    }

    /**
     * Checks whether the name entered and the entity denoted by that name
     * matches the configured constraints on this editor.
     */
    void checkInputConstraints(String input, ClassElement result) 
        throws IllegalArgumentException {
        // the first case is, that the result is null -> input was not found.
            
        if (result == null) {
            if (!getValidNamesOnly()) {
                // cannot verify that the name conforms to constraints,
                // but can't reject it either.
                return;
            }
            throw new IllegalArgumentException("Cannot find class or interface " + input); // NOI18N
        }
        
        boolean properClass = result.isClassOrInterface();
        
        if (properClass && !getAcceptClasses()) {
            throw new IllegalArgumentException("Class name is not permitted here"); // NOI18N
        }
        
        if (!properClass && !getAcceptInterfaces()) {
            throw new IllegalArgumentException("Interface name is not permitted here"); // NOI18N
        }
    }

    public java.awt.Component getCustomEditor() {
        Thread.dumpStack();
        // XXX needs to be rewritten somehow
        return new javax.swing.JPanel();
        /*
        if (customEditor == null) {
            Enumeration en = FileSystemCapability.COMPILE.fileSystems();
            Collection roots = new LinkedList();
            
            while (en.hasMoreElements()) {
                FileObject f = ((FileSystem)en.nextElement()).getRoot();
                try {
                    Object o = DataObject.find(f).getCookie(DataObject.Container.class);
                    roots.add(o);
                } catch (DataObjectNotFoundException ex) {
                }
            }
            customEditor = new ClassChooserPanel(this, roots);
        }
        return customEditor;
         */
    }
    
    /*
    PropertyValueAcceptor getAcceptor() {
    }
    
    static final class AllAcceptor extends PropertyValueAcceptor {
    }
     */
}
