/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.tools;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.*;
import java.util.Iterator;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.*;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.*;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

/** This action allows the user to override some of the methods present in the
 * selected class.
 * The action displays a modal dialog with several lists, then overrides
 * one or more methods the user selects.
 */
public class OverrideAction extends NodeAction {
    
    private DelegateTextAction delegateAction = new DelegateTextAction();
    
    static String getString(String key) {
        return NbBundle.getMessage(OverrideAction.class, key);
    }
    
    public OverrideAction () {
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    public HelpCtx getHelpCtx() {
        return null;
    }
    
    public String getName() {
        return getString("LAB_OverrideTool");
    }
    
    public void performAction(final Node[] activatedNodes) {
        Runnable run = new Runnable() {
            public void run() {
                ClassDefinition el = getJavaClass(activatedNodes[0]);
                boolean isInterface = el instanceof JavaClass && ((JavaClass)el).isInterface();
                if (isInterface) {
                    NotifyDescriptor nd = new NotifyDescriptor(
                            getString("LAB_OverrideWarningDiagText"),
                            getString("LAB_OverrideWarningDiagTitle"),
                            NotifyDescriptor.DEFAULT_OPTION,
                            NotifyDescriptor.WARNING_MESSAGE,
                            null,
                            null
                    );
                    DialogDisplayer.getDefault().notify(nd);
                    return;
                }
                if (el == null) return;

                JMIInheritanceSupport support = new JMIInheritanceSupport(el);

                String title = MessageFormat.format(getString("LBL_OverridePanel2_Title"), //NOI18N
                new Object[] { el.getName() } );
                OverridePanel2 panel = new OverridePanel2(support);
                final DialogDescriptor desc = new DialogDescriptor(panel, title, true, DialogDescriptor.OK_CANCEL_OPTION, DialogDescriptor.OK_OPTION, null);
                panel.addPropertyChangeListener(new PropertyChangeListener() {
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (OverridePanel2.PROP_VALID.equals(evt.getPropertyName())) {
                            desc.setValid(((Boolean) evt.getNewValue()).booleanValue());
                        }
                    }
                });
                HelpCtx ctx = new HelpCtx(OverrideAction.class.getName());
                desc.setHelpCtx(ctx);

                Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
                dialog.setVisible(true);
                dialog.dispose();

                if (desc.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    Collection methods = panel.getMethods();
                    Method first = null;
                    int index = 0;

                    MDRepository repository = JavaMetamodel.getDefaultRepository();
                    boolean failed = true;
                    repository.beginTrans(true);
                    try {
                        if (!el.isValid()) {
                            el = getJavaClass(activatedNodes[0]);
                            support.setRootClass(el);
                        }
                        for (Iterator i = methods.iterator(); i.hasNext(); ) {
                            Method m = (Method) i.next();
                            m = support.overrideMethod(m, panel.isGenerateSuperCalls(), panel.isGenerateJavadoc());
                            if (first == null) {
                                first = m;
                                index = el.getFeatures().indexOf(m);
                            }
                        }
                        failed = false;
                    } finally {
                        repository.endTrans(failed);
                    }

                    if (first != null) {
                        PositionBounds bounds = null;
                        repository.beginTrans(false);
                        try {
                            if (!first.isValid()) {
                                if (!el.isValid())
                                    el = getJavaClass(activatedNodes[0]);
                                List list = el.getFeatures();
                                if (list.size() > index) {
                                    Iterator iter = list.iterator();
                                    Object obj = null;
                                    for (int x = 0; x <= index; x++)
                                        obj = iter.next();
                                    // Object obj = list.get(index);
                                    if (obj instanceof Method) {
                                        first = (Method)obj;
                                    }
                                }
                            }
                            if (first.isValid()) {
                                bounds = JavaMetamodel.getManager().getElementPosition(first);
                            }
                        } finally {
                            repository.endTrans();
                        }
                        if (bounds != null) {
                            PositionRef beginPos = bounds.getBegin();
                            CloneableEditorSupport editSupp = beginPos.getCloneableEditorSupport();
                            JEditorPane[] panes = editSupp.getOpenedPanes();
                            if (panes==null) {
                                editSupp.open();
                            }
                        }
                    }
                }
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(run, getString("LBL_OverridePanel2_Title"));
    }
    
    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        
        Element elem = getElement(activatedNodes[0]);
        return elem != null;
    }
    
    private Element getElement(Node n) {
        Element el = (Element) n.getLookup().lookup(Element.class);
        if (el == null) {
            JavaDataObject jdo = (JavaDataObject) n.getCookie(JavaDataObject.class);
            if (jdo !=null)
                el = JavaMetamodel.getManager().getResource(jdo.getPrimaryFile());
            if (el==null)
                return null;
        }
        
        if (!((el instanceof Resource) || (el instanceof ClassMember) || (el instanceof ClassDefinition))) {
            el = null;
        }
        return el;
    }
    
    private ClassDefinition getJavaClass(Node n) {
        // force reparse of the source if it was modified
        MDRepository repository = JavaMetamodel.getDefaultRepository();
        repository.beginTrans(true);
        repository.endTrans();
        
        int caretPosition = -1;
        EditorCookie ec = (EditorCookie) n.getCookie(EditorCookie.class);
        if (ec != null) {
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (activetc instanceof CloneableEditorSupport.Pane) {
                JEditorPane pane = ((CloneableEditorSupport.Pane)activetc).getEditorPane();
                JTextComponent textComponent = delegateAction.getTextComponent();
                if (textComponent == null) {
                    return null;
                }
                
                if (textComponent.equals(pane)) {
                    caretPosition = textComponent.getCaretPosition();
                }
            }
        }
        Element el = null;
        if (caretPosition != -1) {
            DataObject dobj = (DataObject)n.getCookie(DataObject.class);
            while (dobj instanceof DataShadow) {
                dobj = ((DataShadow) dobj).getOriginal();
            }
            el = JavaMetamodel.getManager().getElementByOffset(dobj.getPrimaryFile(), caretPosition);
        } else {
            el = getElement(n);
        }
        
        if (el==null)
            return null;

        while (!(el instanceof ClassDefinition) && !(el instanceof Resource)) {
            el = (Element)el.refImmediateComposite();
        }

        if (el instanceof Resource) {
            for (Iterator iter = ((Resource) el).getClassifiers().iterator(); iter.hasNext(); ) {
                Object obj = iter.next();
                if (obj instanceof JavaClass) {
                    return (JavaClass) obj;
                }
            }
            return null;
        }
        return (ClassDefinition) el;
    }   
    
    protected boolean asynchronous() {
        return false;
    }
    
    // ..........................................................................
    private static final class DelegateTextAction extends TextAction {
        
        public DelegateTextAction() {
            super("");
        }
        
        public void actionPerformed(ActionEvent a) {
        }
        
        public JTextComponent getTextComponent() {
            return getFocusedComponent();
        }
    }; // DelegateTextAction
    
}
