/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.tools;

import java.awt.*;
import javax.swing.*;
import java.lang.reflect.Modifier;

import org.openide.src.*;
import org.openide.util.Utilities;

/**
 * ListCellRenderer capable of displaying some Java elements according to the
 * element format
 */
public class ElementRenderer extends DefaultListCellRenderer {
    /** Icons for the displayed elements.
     */
    private static ImageIcon elementIcons[];

    private static final int PUBLIC_OFFSET = 0;
    private static final int PROTECTED_OFFSET = 1;
    private static final int PRIVATE_OFFSET = 2;
    private static final int PACKAGE_OFFSET = 3;
    
    private static final int METHOD_BASE = 0;
    private static final int CLASS_BASE = 4;

    static {
        elementIcons = new ImageIcon[8];
        
        elementIcons[ METHOD_BASE + PUBLIC_OFFSET ] = new ImageIcon (Utilities.loadImage ("org/openide/src/resources/methodPublic.gif") ); // NOI18N
        elementIcons[ METHOD_BASE + PROTECTED_OFFSET ] = new ImageIcon (Utilities.loadImage ("org/openide/src/resources/methodProtected.gif") ); // NOI18N
        elementIcons[ METHOD_BASE + PRIVATE_OFFSET ] = new ImageIcon (Utilities.loadImage ("org/openide/src/resources/methodPrivate.gif") ); // NOI18N
        elementIcons[ METHOD_BASE + PACKAGE_OFFSET ] = new ImageIcon (Utilities.loadImage ("org/openide/src/resources/methodPackage.gif") ); // NOI18N
        
        elementIcons[ CLASS_BASE + PUBLIC_OFFSET ] = new ImageIcon (Utilities.loadImage ("org/openide/src/resources/class.gif") ); // NOI18N
	// No special icons for diffent access type for classes.
        elementIcons[ CLASS_BASE + PROTECTED_OFFSET ] = elementIcons[ CLASS_BASE + PUBLIC_OFFSET ];
        elementIcons[ CLASS_BASE + PRIVATE_OFFSET ] = elementIcons[ CLASS_BASE + PUBLIC_OFFSET ];
        elementIcons[ CLASS_BASE + PACKAGE_OFFSET ] = elementIcons[ CLASS_BASE + PUBLIC_OFFSET ];
    }

    /** Formatting object to use with this Renderer.
     */
    private ElementFormat elementFormat;

    /** Creates new element renderer.
     * Note that you <b>must</b> call {@link #setFormat} before the first item is painted.
     */
    public ElementRenderer() {
    }

    /** Creates an renderer and sets the element format to use.
     */
    public ElementRenderer(ElementFormat fmt) {
        this();
        setFormat(fmt);
    }
    
    public void setFormat(ElementFormat fmt) {
        this.elementFormat = fmt;
    }
    
    public java.awt.Component getListCellRendererComponent(final javax.swing.JList list,
        final java.lang.Object value,int index,boolean selected,boolean focused) {
        Component c = super.getListCellRendererComponent(list, null, index, selected, focused);
        
        if (!(c instanceof JLabel))
            return c;
        JLabel label = (JLabel)c;
        label.setIcon(getIcon(value));
        label.setText(elementFormat.format((MethodElement)value));
        return c;
    }
    
    protected Icon getIcon(Object element) {
        int modifiers;
        int base;
        Element el;
        
        if (element instanceof MemberElement) {
            modifiers = ((MemberElement)element).getModifiers();
            el = (MemberElement)element;
            if (el instanceof ClassElement) {
                base = CLASS_BASE;
            } else if (el instanceof MethodElement) {
                base = METHOD_BASE;
            } else 
                throw new IllegalArgumentException(element.getClass().toString());
        } else {
            throw new IllegalArgumentException(element.getClass().toString());
        }
        
        int offset;
        
        if (Modifier.isPublic(modifiers))
            offset = PUBLIC_OFFSET;
        else if (Modifier.isProtected(modifiers)) 
            offset = PROTECTED_OFFSET;
        else if (Modifier.isPrivate(modifiers)) 
            offset = PRIVATE_OFFSET;
        else 
            offset = PACKAGE_OFFSET;
        
        return elementIcons[base + offset];
    }
}
