/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.settings;

import java.awt.Image;
import java.beans.*;
import java.util.ResourceBundle;

import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/** BeanInfo for class JavaSynchronizationSettings.
* It describes three properties one with special editor.
*
* @author Petr Hamernik
*/
public class JavaSynchronizationSettingsBeanInfo extends SimpleBeanInfo {

    /** Returns the ExternalCompilerSettings' icon */
    public Image getIcon(int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16)) {
            return Utilities.loadImage("org/netbeans/modules/java/resources/synchronizeSettings.gif"); // NOI18N
        } else {
            return Utilities.loadImage("org/netbeans/modules/java/settings/javaSynchronizationSettings32.gif"); // NOI18N
        }
    }

    /** Descriptor of valid properties
    * @return array of properties
    */
    public PropertyDescriptor[] getPropertyDescriptors () {
        try {
            PropertyDescriptor[] desc = new PropertyDescriptor[] {
                       new PropertyDescriptor(JavaSynchronizationSettings.PROP_GENERATE_RETURN,
                                              JavaSynchronizationSettings.class, "getGenerateReturn", "setGenerateReturn"), // NOI18N
                   };
            ResourceBundle bundle = NbBundle.getBundle(JavaSynchronizationSettingsBeanInfo.class);

            desc[0].setDisplayName(bundle.getString("PROP_GENERATE_RETURN"));
            desc[0].setShortDescription(bundle.getString("HINT_GENERATE_RETURN"));
            desc[0].setPropertyEditorClass(RetGenEditor.class);

	    return desc;
        }
        catch (IntrospectionException ex) {
	    ErrorManager.getDefault().notify(ex);
	    return null;
        }
    }

    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor desc = new BeanDescriptor(JavaSettings.class);
        desc.setDisplayName(JavaSettings.getString("CTL_JavaSynchronization_Settings"));
        return desc;
    }

    /** Simple property editor for two-item pulldown. */
    public static class RetGenEditor extends PropertyEditorSupport {

        private static final String[] tags;

        static {
            tags = new String[3];
            ResourceBundle bundle = NbBundle.getBundle(JavaSynchronizationSettingsBeanInfo.class);
            tags[JavaSynchronizationSettings.RETURN_GEN_NOTHING] = bundle.getString("CTL_RETURN_GEN_NOTHING");
            tags[JavaSynchronizationSettings.RETURN_GEN_EXCEPTION] = bundle.getString("CTL_RETURN_GEN_EXCEPTION");
            tags[JavaSynchronizationSettings.RETURN_GEN_NULL] = bundle.getString("CTL_RETURN_GEN_NULL");
        }

        public String[] getTags () {
            return tags;
        }

        public String getAsText () {
            return tags[((Integer) getValue ()).intValue ()];
        }

        public void setAsText (String text) throws IllegalArgumentException {
            for (int i = 0; i < tags.length; i++) {
                if (tags[i].equals (text)) {
                    setValue (new Integer (i));
                    return;
                }
            }
            throw new IllegalArgumentException ();
        }
    }

}

