/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.settings;

import java.beans.*;
import java.util.HashMap;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;

import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/** A settings for synchronization (connections) of java sources.
*
* @author Petr Hamernik
*/
public class JavaSynchronizationSettings extends SystemOption {
    /** generated Serialized Version UID */
    static final long serialVersionUID = 24341252342342345L;

    public static final String PROP_GENERATE_RETURN = "generateReturn"; // NOI18N

    public static final int RETURN_GEN_NOTHING = 0;
    public static final int RETURN_GEN_EXCEPTION = 1;
    public static final int RETURN_GEN_NULL = 2;

    private static final String[] RETURN_STRINGS = {
        "\n", "\nthrow new UnsupportedOperationException();\n", "\nreturn null;\n" // NOI18N
    };

    private static final HashMap RETURN_STRINGS_PRIMITIVE;

    static {
        String number = "\nreturn 0;\n"; // NOI18N
        RETURN_STRINGS_PRIMITIVE = new HashMap();
        RETURN_STRINGS_PRIMITIVE.put("void", RETURN_STRINGS[RETURN_GEN_NOTHING]); // NOI18N
        RETURN_STRINGS_PRIMITIVE.put("boolean", "\nreturn false;\n"); // NOI18N
        RETURN_STRINGS_PRIMITIVE.put("int", number); // NOI18N
        RETURN_STRINGS_PRIMITIVE.put("char", "\nreturn ' ';\n"); // NOI18N
        RETURN_STRINGS_PRIMITIVE.put("byte", number); // NOI18N
        RETURN_STRINGS_PRIMITIVE.put("short", number); // NOI18N
        RETURN_STRINGS_PRIMITIVE.put("long", number); // NOI18N
        RETURN_STRINGS_PRIMITIVE.put("float", number); // NOI18N
        RETURN_STRINGS_PRIMITIVE.put("double", number); // NOI18N
    }

    private static int generateReturn = RETURN_GEN_NOTHING;

    /** human presentable name */
    public String displayName() {
        return NbBundle.getBundle(JavaSynchronizationSettings.class).getString("CTL_JavaSynchronization_Settings");
    }

    public HelpCtx getHelpCtx () {
        return new HelpCtx (JavaSynchronizationSettings.class);
    }

    public int getGenerateReturn() {
        return generateReturn;
    }

    public void setGenerateReturn(int val) {
        if (generateReturn != val) {
            int old = generateReturn;
            generateReturn = val;
            firePropertyChange(PROP_GENERATE_RETURN, new Integer(old), new Integer(val));
        }
    }

    public String getGenerateReturnAsString(Type type) {
        if (generateReturn == RETURN_GEN_NULL) {
            if (type instanceof PrimitiveType)
                return (String) RETURN_STRINGS_PRIMITIVE.get(type.getName());
            else
                return RETURN_STRINGS[RETURN_GEN_NULL];
        }
        else
            return RETURN_STRINGS[generateReturn];
    }
}
