/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.settings;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.SimpleBeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.BeanDescriptor;

import org.openide.ErrorManager;
/**
*
* @author Ales Novak
*/
public class JavaSettingsBeanInfo extends SimpleBeanInfo {
    
    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor desc = new BeanDescriptor(JavaSettings.class);
        desc.setDisplayName(JavaSettings.getString("CTL_Java_option"));
        /* for POST-FCS desc.setShortDescription(JavaSettings.getString("HINT_Java_option")); */
        return desc;
    }


    /** Descriptor of valid properties
    * @return array of properties
    */
    public PropertyDescriptor[] getPropertyDescriptors () {
        try {
            PropertyDescriptor[] desc = new PropertyDescriptor[] {
                       new PropertyDescriptor (JavaSettings.PROP_REPLACEABLE_STRINGS_TABLE, JavaSettings.class),
                       new PropertyDescriptor (JavaSettings.PROP_AUTO_PARSING_DELAY, JavaSettings.class),
                       new PropertyDescriptor (JavaSettings.PROP_PARSING_ERRORS, JavaSettings.class),
                       new PropertyDescriptor (JavaSettings.PROP_SHOW_COMPILE_STATUS, JavaSettings.class, "isCompileStatusEnabled", "enableCompileStatus"), // NOI18N
                       new PropertyDescriptor (JavaSettings.PROP_DEFAULT_ENCODING, JavaSettings.class),
                       new PropertyDescriptor (JavaSettings.PROP_SHOW_OVERRIDING, JavaSettings.class)
                   };

            int index = 0;
            
            desc[index].setDisplayName (JavaSettings.getString("PROP_REPLACEABLE_STRINGS"));
            desc[index].setShortDescription (JavaSettings.getString("HINT_REPLACEABLE_STRINGS"));
            index++;
            desc[index].setDisplayName (JavaSettings.getString("PROP_AUTO_PARSING_DELAY"));
            desc[index].setShortDescription (JavaSettings.getString("HINT_AUTO_PARSING_DELAY"));
            index++;
            desc[index].setDisplayName (JavaSettings.getString("PROP_PARSING_ERRORS"));
            desc[index].setShortDescription (JavaSettings.getString("HINT_PARSING_ERRORS"));
            index++;
            desc[index].setDisplayName(JavaSettings.getString("PROP_SHOW_COMPILE_STATUS"));
            desc[index].setShortDescription(JavaSettings.getString("HINT_SHOW_COMPILE_STATUS"));
            index++;
            desc[index].setExpert(true);
            desc[index].setDisplayName(JavaSettings.getString("PROP_DEFAULT_ENCODING"));
            desc[index].setShortDescription(JavaSettings.getString("HINT_DEFAULT_ENCODING"));
            index++;
            desc[index].setDisplayName(JavaSettings.getString("PROP_SHOW_OVERRIDING"));
            desc[index].setShortDescription(JavaSettings.getString("HINT_SHOW_OVERRIDING"));
            return desc;
        } catch (IntrospectionException ex) {
	    ErrorManager.getDefault().notify(ex);
            return null;
        }
    }

    /**
    * Claim there are no icons available.  You can override
    * this if you want to provide icons for your bean.
    */
    public Image getIcon(int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16)) {
            return org.openide.util.Utilities.loadImage("org/netbeans/modules/java/resources/class.gif"); // NOI18N
        } else { // 32
            return org.openide.util.Utilities.loadImage("org/netbeans/modules/java/resources/class32.gif"); // NOI18N
        }
    }
}
