/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.parser;

import org.netbeans.modules.java.ParserMessage;

/*
 * This class represents a single error encountered when parsing
 * a java file. 
 * <p>
 * @author Tor Norbye <tor@netbeans.org>
 */

class ParserMessageImpl extends ParserMessage {
    private final int line;
    private final int column;
    private final Object severity;
    private final String message;

    /** Construct new ParserMessage.
     * @param file The file where the error occurred.
     * @param line The line number where the error occurred
     * @param column The column within the line where the error
     *    occurred.
     * @param message Messages from the compiler describing
     *    the error
     */
     ParserMessageImpl(Object sev, int l, int col, String msg) {
        severity = sev;
        line = l;
        column = col;
        message = msg;
    }

    /** Return the line number on which the error occurred.
     *  @return the line number on which the error occurred.
     */
    public int getLineNumber() {
        return line;
    }

    /** Return the severity on which the error occurred.
     *  @return the severity on which the error occurred.
     */
    public Object getSeverity() {
        return severity;
    }
    
    /** Return the column number within the line on which the error occurred.
     *  @return the column number within the line on which the error occurred.
     */
    public int getColumn() {
        return column;
    }
    
    /** Return the text description of the error
     * @return the text description of the error
     */
    public String getDescription() {
        return message;
    }

    /** For debugging only */
    public String toString() {
        return line + ":" + column + ":" + message; // NOI18N
    }
}

