/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.parser;

import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.ErrConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import org.netbeans.api.java.classpath.ClassPath;

/** Request for parsing the Java source. This interface defines interactions
    between the parsing engine and the request object.
    Parser engine takes appropriate DataObject from the request and processes
    its file. The engine consults the request about its validity from time to 
    time so it can stop time-consuming processing as soon as possible.
    The main purpose is to inform the Request about states of processing so it
    can properly track its validity.
*
* @author Petr Hamernik
*/
public interface ParseObjectRequest {
    /** Sets the number of syntax errors that occured during parsing.
    */
    public void setSyntaxErrors(int errors);
    
    /** Returns the number of syntax errors.
    */
    public int  getSyntaxErrors();
    
    /** 
     * Sets number of semantic errors.
     */
    public void setSemanticErrors(int errors);
    
    /** Returns Element implementation creation factory. The Engine asks for the
        factory after it finishes general text scan. The factory will be responsible
        for creating the source text representation and to bind it to the request.
    */
    public ElementFactory getFactory();
    
    /** 
     * Called to obtain data to be parsed. 
     * @throws IOException if the data can't be returned.
    */
    public char[] getSource() throws IOException;

    /**
     * Returns a FileObject for up-to-date classfile that corresponds to the
     * passed classname.
     * The method ought to return null if the .class is out of date.
     * @return FileObject containg .class for the given class name. The value can
     * be null if the .class can't be found, is not up-to-date or the feature 
     * is not supported.
     */
    public InputStream findCompiledClass(String className);

    /** Determines if the request is still valid.
        In general, request processing stops whenever this method returns false.
        It is <B>required</B> that implementation returns false, if the source contents
        changes during request processing.
        Implementation might return false whenever it decides to discard potential results
        from this request to provide hint to the Parser Engine.
    */
    public boolean isValid();

    public boolean needsProcessing();
    
    /** Notifies the request that the parser engine is about to process the request.
        Should any data passed to the parser engine change after this call, the
        parser request implementation should invalidate the request.
    */
    public void notifyStart();

    /** Notifies the request object that the engine has finished its processing.
        The request can then become completed (depending on its validity)
    */
    public void notifyComplete();
    
    public Object getParserType();
 
    /** @return the set of errors encountered while processing this
     * request */
    public Collection getMessages();
   
    public ErrConsumer getErrConsumer();
    
    public String getSourceName();
    
    public ClassPath getLibraryPath();
    public ClassPath getBootClassPath();
    public ClassPath getSourcePath();
}
