/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.codegen;

import java.util.Collection;

import org.openide.src.Element;
import org.openide.text.PositionBounds;

import org.netbeans.modules.java.bridge.Binding;

/**
 * Interface for binding Elements to org.openide.text.* package.
 *
 * @author  sdedic
 * @version 
 */
public interface TextBinding extends Binding {
    /** Bounds for the whole element.
     */
    public static final int BOUNDS_ALL = 0;
    
    /** Bounds that will contain javadoc comment.
     */
    public static final int BOUNDS_JAVADOC = 1;
    
    /** Bounds that will contain the header of a method, declarator of a field,
     * or header of a class.
     */
    public static final int BOUNDS_HEADER = 2;
    
    /** Bounds for body of a constructor/method/initializer/class, or init value
     * for a field. Undefined otherwise.
     */
    public static final int BOUNDS_BODY = 3;

    public static final int BOUNDS_FIELD_TYPE = 4;
    
    /** Bounds suitable for the package statement. 
     */
    public static final int BOUNDS_PACKAGE = 10;
    
    public static final int BOUNDS_SOURCE = 10;
    
    /**
     * Returns the associated java Element.
     */
    public org.openide.src.Element getElement();
    
    /**
     * Returns the range occupied by the element.
     * @param if true, the returned range will not include javadoc.
     */
    public PositionBounds   getElementRange(boolean defRange);
    
    /**
     * Returns a container of the specified type, or null if there is not any.
     */
    public Container getContainer(String containerType);
    
    /**
     * Updates the specified bounds. Exact types can have element-specific meaning.
     */
    public void updateBounds(int boundsType, PositionBounds bounds);
    
    /**
     * A special method for linking fields, that are declared in one declarator
     * together.
     */
    public void linkAfter(TextBinding previousBinding);
    
    /** Extension for container bindings.
     */
    public interface Container extends Binding.Container {
        public void updateChildren(Collection members);
        public boolean isEmpty();
    }
    
    public interface ExElement extends javax.swing.text.Element {
        public org.openide.text.PositionRef getDeclarationStart();
    }
}
