/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.codegen;

import org.openide.src.*;
import org.openide.text.*;

import org.netbeans.modules.java.bridge.Binding;

/**
 *
 * @author  Svatopluk Dedic <mailto:sdedic@netbeans.org>
 * @version 0.1
 */
class Initializer extends ElementBinding implements Binding.Initializer {
    /** This body string will be returned from getBody(), if not null.
     */
    private String  preexistingBody;
    
    public Initializer(InitializerElement el, SourceText s) {
        super(el, s);
    }
    
    public void create(PositionBounds b) throws SourceException {
        super.create(b);
        preexistingBody = null;
    }

    private InitializerElement getInitializer() {
        return (InitializerElement)getElement();
    }
    
    private InitializerElement cloneInitializer() {
        return (InitializerElement)cloneElement();
    }
    
    protected int classifyProperty(String name) {
        if (name == PROP_BODY)
            return CLASS_BODY;
        else
            return CLASS_HEADER;
    }
    
    protected Element cloneElement() {
        InitializerElement initEl = new InitializerElement();
        try {
            initEl.setStatic(getInitializer().isStatic());
        } catch (SourceException ex) {
        }
        return initEl;
    }
    
    /**
     * Changes static <-> nonstatic
     */
    public void changeStatic(boolean enable) throws SourceException {
        if (!source.isGeneratorEnabled())
            return;
        
        InitializerElement iel = cloneInitializer();
        iel.setStatic(enable);
        regenerateHeader(iel);
    }
    
    /**
     * Updates the storage binding object from an external SourceText.
     */
    public void updateFrom(Binding other) {
    }
    
    public String getBodyContent() throws SourceException {
        if (preexistingBody != null)
            return preexistingBody;
        return CodeGenerator.readTextBounds(bodyBounds);
    }
    
    public void changeBody(String bodyString) throws SourceException {
        if (!source.isGeneratorEnabled())
            return;
        
        InitializerElement ie = cloneInitializer();
        ie.setBody(bodyString);
        source.runAtomic(getElement(), new PartialGenerator(source.getDocument(),
            ie, bodyBounds, ElementPrinter.BODY_BEGIN, ElementPrinter.BODY_END));
    }
    
    public void copyBody(String bodyString) {
        this.preexistingBody = bodyString;
    }
}
