/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;

import org.openide.src.SourceException;
import org.openide.util.NbBundle;

import org.openide.ErrorManager;

/**
 *
 * @author  sdedic
 * @version 
 */
class Util extends Object {
    /** ResourceBundle for java-loader package. */
    static ResourceBundle bundle;

    /** Computes the localized string for the key.
    * @param key The key of the string.
    * @return the localized string.
    */
    static String getString(String key) {
        if (bundle == null)
            bundle = NbBundle.getBundle(Util.class);
        return bundle.getString(key);
    }

    static void throwException(String desc, String bundleKey) throws SourceException {
	throw (SourceException)ErrorManager.getDefault().annotate(
	    new SourceException(desc),
	    getString(bundleKey)
	);
    }
    
    static PropertyChangeEvent computePropretyDiffs(Object[] oldValues, Object[] newValues) {
        if (newValues.length == oldValues.length)
            // array lengths match, there's a change or a reorder.
            return null;
            //return computeChange(oldValues, newValues);
        return null;
    }
    
    /*
    static org.openide.ErrorManager getErrorManager() {
        return ErroManager.getDefault().getInstance("org.netbeans.modules.java.model"); // NOI18N
    }
     */
    
    static ErrorManager em;
    
    static void log(String msg) {
        if (em == null) {
            synchronized (Util.class) {
                if (em == null)
                    em = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.model"); // NOI18N
            }
        }
        em.log(msg);
    }
}
