/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.util.*;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.*;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.JavaClass;
import org.openide.src.*;


class TopClassesCollection extends ClassesCollection {
    
    private Resource resource;
    private SourceElementImpl sourceImpl;
    
    public TopClassesCollection(FeaturesCollection members, Resource resource, SourceElementImpl sourceImpl) {
        super (members);
        this.resource = resource;
        this.sourceImpl = sourceImpl;
    }

    public RefObject createFeature(RefObject parent, Element elem) {
        JavaClass res = members.createClass ((ClassElement) elem);
        return res;
    }
    
    public boolean isClassMember () {
        return false;
    }
    
    public List getFeatures () {
        members.repository.beginTrans(false);
        try {
            return resource.getClassifiers();
        } finally {
            members.repository.endTrans();
        }
    }
    
    public boolean isValid() {
        return resource.isValid();
    }
    
    public Element createElement(RefObject topClass) {
        return (ClassElement) members.model.createTopClass ((SourceElement) sourceImpl.getElement (), (JavaClass)topClass).getElement ();
    }

    protected void addMembers (Element[] items) throws SourceException {
        if (items.length == 0)
            return;
        
        members.repository.beginTrans (true);
        boolean failed = true;
        try {
            if (isValid()) {
                members.parentImpl.setClassPath();
                List features = getFeatures ();
                for (int x = 0; x < items.length; x++) {
                    features.add (createFeature (members.javaClass, items[x]));
                }            
                failed = false;
            } else {
                failed = false;
                members.parentImpl.throwIsInvalid ();
            }
        } finally {
            members.repository.endTrans (failed);
        }
    }
    
    protected void setMembers (Element[] items) throws SourceException {                
        members.repository.beginTrans (true);
        boolean failed = true;
        try {
            if (isValid()) {
                members.parentImpl.setClassPath();
                List features = getFeatures ();
                features.clear ();
                for (int x = 0; x < items.length; x++) {
                    features.add (createFeature (members.javaClass, items[x]));
                }            
                failed = false;
            } else {
                failed = false;
                members.parentImpl.throwIsInvalid ();
            }
        } finally {
            members.repository.endTrans (failed);
        }
    }
    
    public ClassElement getClass(Identifier name) {
        String clsName = name.getName ();
        if (clsName == null)
            return null;        
        members.repository.beginTrans (false);
        try {
            if (isValid()) {
                Iterator iter = resource.getClassifiers ().iterator ();                                     
                while (iter.hasNext ()) {
                    Object obj = iter.next ();
                    if (!(obj instanceof JavaClass)) {
                        continue;
                    }
                    JavaClass cls = (JavaClass) obj;
                    String clsFullName = cls.getName();
                    String clsSimpleName = cls.getSimpleName();
                    if (clsName.equals (clsSimpleName)) {
                        String fqn = name.getFullName ();
                        if (!fqn.equals (clsSimpleName) && !fqn.equals (clsFullName))
                            return null;
                        else
                            return (ClassElement) cachedElement (cls);
                    } // if
                } // while
                return null;
            } else {
                return null;
            }
        } finally {
            members.repository.endTrans (false);        
        }
    }
    
    // ..........................................................................
    
    static class TopClassesListener extends ObjectsCollection.FeaturesListener {
    
        TopClassesListener (ElementImpl impl) {
            super (impl);
            fireMembers = false;
        }
        
        public void connect () {
            if (REGISTER_LISTENER) {
                ((MDRChangeSource) javaElement).addListener (this);
                features = new ArrayList ();
                Iterator iter = ((Resource) javaElement).getClassifiers ().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof JavaClass) {
                        features.add (obj);
                    }
                } // while
            }
        }
        
        public ObjectsCollection getFeatureCollection (RefObject feature) {
            return ((SourceElementImpl) impl).topClasses;            
        }
                
        protected boolean isWatchedAttribute (AttributeEvent ev) {
            return ev.getAttributeName ().equals ("classifiers"); // NOI18N
        }
        
        public Element cachedElement (RefObject f) {
            if (f instanceof JavaClass) {
                return ((SourceElementImpl) impl).topClasses.cachedElement (f);
            } else {
                return null;
            }
        }

    }
    
}
