package org.netbeans.modules.java.bridge;

/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.*;
import java.util.*;

import org.netbeans.api.java.classpath.ClassPath;
import org.openide.ErrorManager;

import org.openide.src.*;

import org.netbeans.api.mdr.events.*;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.nodes.Node;

import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class SourceElementImpl extends ElementImpl implements SourceElement.Impl, ElementOrder,
    PropertyChangeListener {

    private transient FeaturesCollection members;
    transient TopClassesCollection topClasses;
    transient ImportsCollection imports;

    private ElementImpl.ElementListener classesListener, sourceListener, importsListener;
    
    private IdentContextSupport identSupp;
    
    private transient Resource resource;
    
    private transient JavaDataObject javaObject;
    
    private static final long serialVersionUID = 8506642610861188475L;
    
    // init .....................................................................
    
    public SourceElementImpl(DefaultLangModel model, Resource resource, JavaDataObject jdo) {                        
        super(model, resource);
        
        this.resource = resource;
        javaObject = jdo;
        identSupp = new IdentContextSupport(11);
        
        members = new FeaturesCollection (this);
        topClasses = new TopClassesCollection (members, resource, this);
        imports = new ImportsCollection (members, (Resource) resource);
    }
    
    public void connectListener () {
        sourceListener = new SourceListener (this);
        sourceListener.connect ();
        classesListener = new TopClassesCollection.TopClassesListener (this);
        classesListener.connect ();
        org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl resImpl =
            (org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl) resource;
        if (resImpl.importsInited()) {
            importsListener = new ImportsCollection.ImportsListener (this);
            importsListener.connect ();
        } else {
            resImpl.addImportsListener(this);
        }
    }        
    
    boolean isResourceValid() {
        return resource.isValid();
    }
    
    // a hack - listens on imports initialization fired by ResourceImpl
    public void propertyChange (PropertyChangeEvent event) {
        importsListener = new ImportsCollection.ImportsListener (this);
        importsListener.connect ();
    }
    
    protected void notifyElementCreated() {
        // do nothing -- override ElementImpl's behaviour.
    }
    
    protected void createFromModel(Element model) throws SourceException {
    }
    
    public Element[] getElements() {
        return getClasses();
    }
    
    public Identifier getPackage() {
        repository.beginTrans(false);
        try {
            if (resource.isValid()) {
                setClassPath();
                String javaPackage = resource.getPackageName();
                return javaPackage  != null ? Identifier.create(javaPackage) : null;
            } else {
                return null;
            }
        } finally {
            repository.endTrans(false);
        }
    }
    
    public Import[] getImports() {
        return imports.getImports ();
    }
    
    public ImportElement[] getImportElements() {
        return (ImportElement[]) imports.getElements ();
    }
    
    public ClassElement getClass(Identifier id) {
        return topClasses.getClass (id);
    }
    
    public ClassElement[] getClasses() {
        return topClasses.getClasses();
    }
    
    public ClassElement[] getAllClasses() {
        ClassElement[] tops = getClasses();
        Collection list = new LinkedList();
        
        for (int i = 0; i < tops.length; i++) {
            addAllClasses(tops[i], list);
        }
        return (ClassElement[])list.toArray(new ClassElement [0]);
    }
    
    private void addAllClasses(ClassElement c, Collection col) {
        col.add(c);
        ClassElement[] inner = c.getClasses();
        for (int i = 0; i < inner.length; i++)
            addAllClasses(inner[i], col);
    }

    // Setters/changers
    ///////////////////////////////////////////////////////////////////////////////////
    public void setPackage(Identifier packageID) throws SourceException {
        checkWritable(false);
        checkDocument();
        boolean failed = true;
        repository.beginTrans (true);
        try {
            if (resource.isValid()) {
                setClassPath();
                Identifier old = getPackage ();
                if (old == packageID ||
                    (old != null && packageID != null && 
                        old.getSourceName().equals(packageID.getSourceName()))) {
                    failed = false;
                    return;
                }
                PropertyChangeEvent evt;
                JavaPackageClass pkgProxy = ((JavaModelPackage)resource.refImmediatePackage()).getJavaPackage();
                String packId=packageID!=null?packageID.getFullName():"";
                JavaClass defClasses[];
                int i;
                evt = new PropertyChangeEvent(getEventSource(), PROP_PACKAGE,
                    old, packageID);
                checkVetoablePropertyChange(evt);

                resource.setPackageName(packId);

                /*
                List defClassesList = new LinkedList();
                Iterator iter = resource.getClassifiers().iterator ();
                while(iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof JavaClass) {
                        defClassesList.add(obj);
                    }
                }
                JavaClass[] defClasses=new JavaClass[defClassesList.size()];
                defClassesList.toArray(defClasses);
                for (i=0;i<defClasses.length;i++) {
                    defClasses[i].setJavaPackage(jpck);
                }
                 */
                failed = false;
            } else {
                failed = false;
                throwIsInvalid ();
            }
        } finally {
            repository.endTrans (failed);
        }
    }

    public void firePackageChange (Identifier oldId, Identifier newId) {
        if (oldId == newId ||
            (oldId != null && newId != null && 
                oldId.getSourceName().equals(newId.getSourceName()))) {            
            return;
        }        
        PropertyChangeEvent evt = new PropertyChangeEvent (
            getEventSource(),
            PROP_PACKAGE,
            oldId, newId
        );
        fireOwnPropertyChange(evt);
        
        // [PENDING]        
        // System.out.println("SourceElementImpl: notifyConnectionChange");
    }
    
    public void changeImports(Import[] defs, int operation) throws SourceException {
        checkWritable(false);
        checkDocument();
        imports.changeImports (defs, operation);
    }
    
    public void changeClasses(ClassElement[] classes, int operation) throws SourceException {        
        checkWritable(false);
        checkDocument();
        topClasses.changeMembers(classes, operation);
    }
    
    private void notifyCreate(Element[] els) {
        for (int i = 0; i < els.length; i++) {
            ElementImpl impl = (ElementImpl)els[i].getCookie(ElementImpl.class);
            impl.notifyCreate();
        }
    }
    
    protected void notifyCreate() {
        /*
        Element[] els;
        
        if (this.imports != null) {
            notifyCreate(imports.getElements());
        }
        if (this.topClasses != null) {
            notifyCreate(topClasses.getElements());
        }
        super.notifyCreate();
         */
    }
    
    private Binding.Source getSourceBinding() {
        return (Binding.Source)getBinding();
    }

    /** Dummy method to satisfy typing requirements. This method does not work with the
     * model, but rather serves as interface to the parser. The method may be implemented
     * in subclasses or delegating implementations.
     */
    public int getStatus() {
        return SourceElement.STATUS_NOT;
    }
    
    public org.openide.util.Task prepare() {
        // [TODO] replace FilesystemChangeMonitor with something else
        //   return FilesystemChangeMonitor.getDefault().parseSourceFile(javaObject);
        return org.openide.util.Task.EMPTY; // [PENDING]
    }
    
    public void runAtomic(Runnable run) {
        boolean failed = true;
        repository.beginTrans (true);
        try {
            setClassPath();
            run.run ();
            failed = false;
        } finally {
            repository.endTrans (failed);
        }
    }
    
    public void runAtomicAsUser(Runnable run) throws SourceException {
        runAtomic (run); // [PENDING]
    }
    
    public void updateMembers(String name, Element[] elements, int[] optMap) {
        /*
        if (name == ElementProperties.PROP_IMPORTS) {
            if (imports == null) { 
                if (elements.length == 0)
                    return;
                initializeImports();
            }
            imports.updateMembers(elements, optMap);
        } else if (name == ElementProperties.PROP_CLASSES) {
            if (topClasses == null) {
                if (elements.length == 0)
                    return;
                initializeClasses();
            }
            topClasses.updateMembers(elements, optMap);
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name); // NOI18N
        }
         */
    }
    
    protected void checkWritable(boolean unsafeOp) throws SourceException {
        SourceException e = null;
        int status = resource.getStatus();
        if ((status & ResourceImpl.HAS_GENERICS) != 0) {
            e = new SourceException.IO("Source containing generics cannot be modified: " + resource.getName()); //NOI18N
        } else if ((status & ResourceImpl.HAS_ANNOTATION) != 0) {
            e = new SourceException.IO("Source containing annotations cannot be modified: " + resource.getName()); //NOI18N
        }
        if (e != null) {
            if (JDK15_CHECKS_DISABLED) {
                if (unsafeOp) {
                    ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
                }
            } else {
                throw e;
            }
        }
    }
    
    // Implementation details
    ///////////////////////////////////////////////////////////////////////////////////
    public void setParent(ElementImpl impl) {
        // no-op, sources cannot have parents.
    }        
    
    protected SourceElementImpl findSource() {
        return this;
    }
    
    public Object readResolve() {
        return null;
    }
    
    protected Element cloneSelf() {
        return null;
    }
    
    protected Identifier createLocalIdentifier(Identifier id, int status) {
        return identSupp.create(id, status);
    }
    
    protected boolean checkIdentifierContext(Identifier id) {
        return identSupp.checkContext(id);
    }
    
    protected boolean parentValid() {
        return isValid();
    }
    
    protected void notifyRemove() {
        /*
        Element[] allElems;
        
        if (imports != null) {
            allElems = imports.getElements();
            for (int i = 0; i < allElems.length; i++) {
                ElementImpl impl = imports.getElementImpl(allElems[i]);
                impl.notifyRemove();
            }
        }
        if (topClasses != null) {
            allElems = topClasses.getElements();
            for (int i = 0; i < allElems.length; i++) {
                ElementImpl impl = topClasses.getElementImpl(allElems[i]);
                impl.notifyRemove();
            }
        }
        super.notifyRemove();
         */
    }
    
    /** Implementation of getCookie(). The implementation fakes cookies of all interfaces
     * on this object; if the cookie is not available, it asks the environment to
     * provide the cookie and IF the cookie descends from the implementation hierarchy
     * passes the request on to the real SourceElement's implementation, optionally
     * parsing it from the source.
     *
     */
    public Node.Cookie getCookie(Class type) {
        if (type.isAssignableFrom(getClass()))
            return this;
        // if (type.isAssignableFrom(JMIElementCookie.class))
        //     return super.getCookie(type);
        return javaObject.getCookie(type);
    }
    
    // ..........................................................................
    
    static class SourceListener extends ElementImpl.ElementListener {
        
        Identifier packageId = null;
        
        SourceListener (SourceElementImpl impl) {
            super (impl);
            String pkgName = ((Resource) javaElement).getPackageName();
            packageId = pkgName != null ? Identifier.create (pkgName) : null;
        }
        
        /*
        public void connect() {
            ((MDRChangeSource) javaElement.refOutermostPackage()).addListener(this);
            super.connect();
        }
        
        public void remove() {
            ((MDRChangeSource) javaElement.refOutermostPackage()).removeListener(this);
            super.remove();
        }
         */
        
        public void doChange(MDRChangeEvent event) {
            super.doChange (event);            
            if ((event instanceof AttributeEvent) &&
                ((AttributeEvent) event).getAttributeName ().equals ("packageName")) { // NOI18N
                Identifier oldId = packageId;
                String name = (String) ((AttributeEvent) event).getNewElement ();
                packageId = name != null ? Identifier.create (name) : null;
                ((SourceElementImpl) impl).firePackageChange (oldId, packageId);
            }
        }
    }
    
}