/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

// import java.beans.PropertyChangeEvent;
import java.util.*;

import org.openide.src.*;

import javax.jmi.reflect.RefObject;

import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.TypeReference;

class MethodsCollection extends ObjectsCollection {

    static final MethodElement[] EMPTY = new MethodElement[0];
    
    public MethodsCollection(FeaturesCollection members) {
        super (members);
    }        

    public RefObject createFeature(RefObject parent, Element elem) {
        Method res = members.createMethod ((MethodElement) elem);
        // res.setDeclaringClass ((JavaClass) parent);
        return res;
    }

    public Element [] getEmptyArray () {
        return EMPTY;
    }
    
    public String getPropertyName () {
        return ElementProperties.PROP_METHODS;
    }
    
    public boolean isOfType (RefObject feature) {
        return feature instanceof Method;
    }
    
    public Element createElement (RefObject method) {
        return (MethodElement) members.model.createMethod (members.getParentClass (), (Method)method).getElement ();
    }
 
    public MethodElement getMethod(Identifier name, Type[] argtypes) {
        members.repository.beginTrans(false);
        try {
            if (isValid()) {
                String methodName = name.getName();
                if (argtypes == null)
                    argtypes = ObjectsCollection.NO_TYPES;
                List args = members.typesToDescriptors (argtypes);
                Method method = members.javaClass.getMethod (methodName, args, false);
                return method == null ? null : (MethodElement)cachedElement (method);
            } else {
                return null;
            }
        } finally {
            members.repository.endTrans();
        }
    }
    
    public MethodElement [] getMethods() {
        return (MethodElement []) getElements ();
    }
    
    public boolean matches (Element elem, RefObject f) {
        Method method = (Method) f;
        MethodElement methodElem = (MethodElement) elem;
        
        // check name
        if (!methodElem.getName ().getName ().equals (method.getName ()))
            return false;
        
        // check return type
        Type returnType2 = methodElem.getReturn ();
        TypeReference returnType = method.getTypeName();
        if (returnType == null) {
            if (returnType2 != null)
                return false;
        } else if (!members.parentImpl.typeReferenceToType (returnType).equals (returnType2))
            return false;
        
        // check parameters
        List params = method.getParameters();
        MethodParameter [] params2 = methodElem.getParameters ();
        if (params.size () != params2.length)
            return false;
        Iterator iter = params.iterator ();
        for (int x = 0; x < params2.length; x++) {
            TypeReference typeRef = ((Parameter) iter.next ()).getTypeName ();
            Type type2 = params2 [x].getType ();
            if (typeRef == null) {
                if (type2 != null)
                    return false;
            } else if (!members.parentImpl.typeReferenceToType (typeRef).equals (type2))
                return false;
        }
        
        return true;
    }
    
    public int getPositionalValue () {
        return ObjectsCollection.POS_VAL_METHOD;
    }
}
