/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import java.util.WeakHashMap;
import javax.jmi.reflect.RefObject;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.cookies.OpenCookie;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.src.*;
import org.openide.text.PositionBounds;

/**
 * Standard stupid & simple implementation of the language model environment.
 *
 * @author  sdedic
 * @version 
 */
public class LangEnvImpl implements LangModel.Env {
    WeakHashMap cookieMap;
    BindingFactory binding;
    WrapperFactory wrapper;
    LangModel model;
    JavaDataObject jdo;
    
    public LangEnvImpl(JavaDataObject jdo) {
        this.jdo = jdo;
        this.binding = new MDRBindingFactory ();
        this.wrapper = DefaultWrapper.getInstance();
        cookieMap = new WeakHashMap(57);
    }
    
    public void setModel(LangModel model) {
        this.model = model;
    }

    public BindingFactory getBindingFactory() {
        return binding;
    }
    
    public WrapperFactory getWrapperFactory() {
        return wrapper;
    }

    /**
     * Currently no-op implementation.
     */
    public void complete(Element scope, int informationKind) {
    }

    /** The environment is called to resolve type name according to the context it
     * is used in. The current implementation will return all primitives and
     * array of primitives unchanged, but will delegate resolution of class names
     * to the {@link #resolveTypeIdent}. If the resolved type identifier is different
     * than the original, it reconstructs the type and returns it.
    */
    public Type resolveType(Element context, Type original) {
        if (original.isPrimitive())
            return original;
        Type t = original;
        int depth = 0;
        while (t.isArray()) {
            t = t.getElementType();
            depth++;
        }
        if (t.isPrimitive())
            return original;

        Identifier id = t.getTypeIdentifier();
        Identifier resolved = resolveTypeIdent(context, id);
        if (resolved == id)
            return original;
        
        // build up the type again.
        t = Type.createClass(resolved);
        while (depth > 0) {
            t = Type.createArray(t);
            depth--;
        }
        return t;
    }
    
    /**
     * This is called to resolve/transform a name of a type for this context.
     * Assume the context will only be ClassElement or SourceElement. This implementation
     * does not attempt to resolve identifiers, it only marks them as 
     * {@link org.openide.src.Identifier#NOT_YET_RESOLVED} to distinguish them from
     * resolved ones.
    */
    public Identifier resolveTypeIdent(Element context, Identifier original) {
        /*
        if (model.isSameContext(context, original))
            return original;
        return model.createLocalIdentifier(context, original.getFullName(), 
            original.getSourceName(), Identifier.NOT_YET_RESOLVED);
         */
        // [PENDING]
        return original;
    }
    
    public Node.Cookie findCookie(Element el, Class requested) {
        Node.Cookie lookup = null;

        if (el instanceof SourceElement)
            // handle it specially for SourceElement - it has much more common with DataObject than
            // the rest of Elements.
            return jdo.getCookie(requested);
        if (requested == OpenCookie.class) {
            lookup = lookupCookie(el, requested);
            if (lookup != null)
                return lookup;
            lookup = createOpenCookie(el);
        } else {
            return jdo.getCookie(requested);
        }
        return lookup;
    }
    
    protected OpenCookie createOpenCookie(Element el) {
        ElementImpl impl = (ElementImpl)el.getCookie(ElementImpl.class);
        OpenCookie ck = new OpenCookieImpl(impl);
        return ck;
    }
    
    private Node.Cookie lookupCookie(Element el, Class clazz) {
        synchronized (cookieMap) {
            Object o = cookieMap.get(el);
            if (o == null)
                return null;
            
            if (o instanceof CookieSet) 
                return ((CookieSet)o).getCookie(clazz);
            
            if (o.getClass().isAssignableFrom(clazz))
                return (Node.Cookie)o;
            return null;
        }
    }
    
    // ..........................................................................
    
    private class OpenCookieImpl implements OpenCookie, Runnable {        
        
        RefObject refObject;
        
        OpenCookieImpl(ElementImpl impl) {            
            refObject = impl.getJavaElement ();            
        }
        
        public void open() {
            // Fix #20551: if the thread is not the event one, replan
            // the open action into the AWT thread.
            org.openide.util.Mutex.EVENT.postReadRequest(this);
        }
        
        public void run() {
            try {
                PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((org.netbeans.jmi.javamodel.Element) refObject);
                if (bounds == null)
                    return;
                ((JavaEditor) jdo.getCookie(JavaEditor.class)).openAt(bounds.getBegin());
            } catch (javax.jmi.reflect.InvalidObjectException e) {
            }
        }
    }
    
}
