/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.bridge;

import org.openide.src.*;
import org.openide.nodes.*;
import java.beans.*;
import java.util.*;

/**
 *
 * @author  sdedic
 * @version 
 */
public class ImportElement extends Element {
    SourceElement   source;
    
    public ImportElement(ImportElement.Impl impl, SourceElement source) {
        super(impl);
        this.source = source;
    }
    
    public SourceElement getSource() {
        return source;
    }
    
    public Import getImport() {
        return ((ImportElement.Impl)impl).getImport();
    }
    
    public void setImport(Import im) throws SourceException {
        ((ImportElement.Impl)impl).setImport(im);
    }
    
    /** Print this element (and all its subelements) into an element printer.
     * @param printer the element printer
     * @exception ElementPrinterInterruptException if the printer canceled the printing
     */
    public void print(ElementPrinter printer) throws ElementPrinterInterruptException {
        Impl i = (Impl)super.impl;
        printer.print(i.getImport().toString());
        printer.print(";"); // NOI18N
    }
    
    public interface Impl extends Element.Impl {
        public Import getImport();
        public void setImport(Import imp) throws SourceException;
    }
    
    public static class MemoryImpl implements Impl {
        
        private Import imp;
        
        public Import getImport () {
            return imp;
        }
        
        public void setImport(Import imp) throws SourceException {
            this.imp = imp;
        }
        
        public Object readResolve() {
            return null;
        }        
        
        public void markCurrent(boolean beforeAfter) {
        }        
        
        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
        
        public void attachedToElement(Element el) {
        }
        
        public void addPropertyChangeListener(PropertyChangeListener l) {
        }
        
        public Node.Cookie getCookie(Class type) {
            return null;
        }
        
    }
    
}
